package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.scope.Reference
import org.mule.weave.v2.ts._

class IsTypeResolver(maybeSource: Option[SourceReference]) extends WeaveTypeResolver {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val lhs = node.incomingEdges().head
    val rhs = node.incomingEdges().last

    rhs.mayBeIncomingType() match {
      case Some(TypeType(patternToMatchType)) =>
        val constraints: VariableConstraints = maybeSource match {
          case Some(source) =>
            val reference: Reference = source.reference
            val posConstraint: VariableConstraint = source.createPositiveConstraint(patternToMatchType, node, ctx)
            val negConstraint: VariableConstraint = source.createNegativeConstraint(patternToMatchType, node, ctx)
            VariableConstraints(Some(Map(reference -> Seq(posConstraint))), Some(Map(reference -> Seq(negConstraint))))
          case None =>
            VariableConstraints.emptyConstraints()
        }

        val value: Option[Boolean] = lhs.mayBeIncomingType() match {
          case Some(expressionType) =>
            val areDisjoint = TypeHelper.areDisjointTypes(expressionType, patternToMatchType)

            //If pattern doesn't match any then is a dead branch
            if (areDisjoint) {
              Some(false)
            } else {
              //If it is assignable then is always true
              val isAssignable = TypeHelper.canBeAssignedTo(expressionType, patternToMatchType, ctx)
              if (isAssignable) {
                Some(isAssignable)
              } else {
                //We don't know it may be true or false
                None
              }
            }

          case None => None
        }

        val res = Some(BooleanType(value, constraints))
        res

      case _ => Some(BooleanType())
    }

  }
}
