package org.mule.weave.v2.utils

import java.util.Optional
import scala.language.implicitConversions

object Optionals {

  implicit def toJavaOptional[T](option: Option[T]): OptionalTransformer[T] = {
    new OptionalTransformer(option)
  }

  class OptionalTransformer[T](option: Option[T]) {
    def asJava: Optional[T] = {
      option match {
        case Some(value) => java.util.Optional.of(value)
        case None        => java.util.Optional.empty()
      }
    }
  }
}
