package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.CanonicalPhaseCategory
import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.MessageKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure.RegexNode
import org.mule.weave.v2.parser.location.WeaveLocation

import scala.util.matching.Regex

class LiteralValidation extends AstNodeVerifier {

  def validateRegex(r: String, location: WeaveLocation, messageCollector: MessageCollector): Unit = {
    try {
      new Regex(r)
    } catch {
      case e: Throwable =>
        messageCollector.error(Message(MessageKind.INVALID_REGEX_MESSAGE_KIND, "Invalid Regex: " + e.getMessage, CanonicalPhaseCategory), location)
    }
  }

  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case RegexNode(r, _) =>
        validateRegex(r, node.location(), context.messageCollector)
      case _ =>
    }
  }
}
