package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.sdk.WeaveResourceResolver
import org.mule.weave.v2.utils.WeaveFile

class ResourceMetrics(val nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver) {
  val time: TimeMetric = new TimeMetric();
  var size: Int = 0
  var extension: String = WeaveFile.fileExtension

  def startFetch(): Unit = {
    time.start()
  }

  def endFetch(size: Int, extension: String): Unit = {
    this.size = size
    time.end()
    this.extension = extension
  }

  def print(): Unit = {
    println(s"|- [${nameIdentifier}] [${extension}] [${resourceResolver.getClass.getSimpleName}] took ${time.duration()}ms [size: ${size}]")
  }
}
