package org.mule.weave.v2.scope

import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import scala.collection.mutable

class ImportInformationResult {
  private val importUsage: mutable.HashMap[NameIdentifier, ImportInformation] = mutable.HashMap()

  def addImportDirective(importDirective: ImportDirective): Unit = {
    importUsage
      .getOrElseUpdate(importDirective.importedModule.elementName, new ImportInformation())
      .addImportDirective(importDirective)
  }

  def addUsage(element: NameIdentifier, from: NameIdentifier): Unit = {
    importUsage.get(from) match {
      case None        => {}
      case Some(value) => value.addUsedElement(element)
    }
  }

  def importsInformation(): Iterable[ImportInformation] = importUsage.values

}

class ImportInformation {
  private val importDirectives: mutable.ArrayBuffer[ImportDirective] = mutable.ArrayBuffer()
  private val usedElements: mutable.ArrayBuffer[NameIdentifier] = mutable.ArrayBuffer()

  def addUsedElement(element: NameIdentifier): Unit = {
    usedElements.+=(element)
  }

  def imports(): Seq[ImportDirective] = importDirectives

  def addImportDirective(id: ImportDirective): Unit = {
    importDirectives.+=(id)
  }

  /**
    * Returns true if the imported module is never used
    *
    * @return
    */
  def isModuleNotUsed(): Boolean = {
    usedElements.isEmpty
  }

  def importedElements(): Seq[ImportDirectiveUsage] = {
    importDirectives.map((id) => {
      val unusedElements = if (id.isImportStart()) {
        Seq.empty
      } else {
        id.subElements.elements
          .map((ie) => ie.elementName)
          .filterNot((ie) => usedElements.contains(ie))
      }
      ImportDirectiveUsage(id, unusedElements)
    })
  }
}

case class ImportDirectiveUsage(importDirective: ImportDirective, unused_element: Seq[NameIdentifier]) {
  def isImportNotUsed(): Boolean = {
    !importDirective.isImportStart() && (importDirective.subElements.elements.nonEmpty && importDirective.subElements.elements.length == unused_element.length)
  }
}