package org.mule.weave.v2.parser.annotation

/**
  * An annotation will add additional information to the node.
  * For example warning messages. Type information or Reference Node
  */
trait AstNodeAnnotation {
  def name(): String

}

trait WithValueAstNodeAnnotation[T] extends AstNodeAnnotation {
  def value(): T
}

/**
  * This trait is for annotations that are not needed when generating
  * the weave executable node.
  *
  * We use it to mark annotations that don't need to be included on bdwl files
  */
trait EphemeralAstNodeAnnotation extends AstNodeAnnotation

object AstNodeAnnotation {
  val OperationDefinitionAnnotationID: String = "op-def"
}
