package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.UntrustedCodeAstNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNodeHelper
import org.mule.weave.v2.parser.ast.header.directives.VersionDirective

/**
  * Injects the untrusted code on the node
  */
class UntrustedCodeAnnotationProcessor extends AbstractScopeAnnotationProcessor {

  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: ScopePhaseAnnotationContext): Unit = {
    annotatedNode match {
      case vd: VersionDirective =>
        val maybePrivileges = AnnotationNodeHelper.argStringSeq("privileges", annotation)
        if (maybePrivileges.isDefined) {
          vd.annotate(UntrustedCodeAstNodeAnnotation(maybePrivileges.get))
        }
      case _ =>
      // Nothing to do
    }
  }
}
