package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.parser.ast.structure.BooleanNode
import org.mule.weave.v2.ts.BooleanType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object BooleanTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    Some(BooleanType(Some(node.astNode.asInstanceOf[BooleanNode].literalValue.toBoolean)))
  }
}
