/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveConstants$;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u000f\u0002!\t\u0005\u0013\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006E\u0002!\te\u0019\u0005\u0006]\u0002!\te\u001c\u0005\u0006c\u0002!IA\u001d\u0005\u0006}\u0002!Ia \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0004\u0002\u001e\u0001!\t%a\b\b\u000f\u0005%R\u0003#\u0001\u0002,\u00191A#\u0006E\u0001\u0003[Aaa\u0011\b\u0005\u0002\u0005=\u0002bBA\u0019\u001d\u0011\u0005\u00111\u0007\u0005\b\u0003kqA\u0011AA\u001a\u0011\u001d\t9D\u0004C\u0001\u0003gAq!!\u000f\u000f\t\u0003\tYD\u0001\u0011DY\u0006\u001c8\u000fT8bI\u0016\u0014x+Z1wKJ+7o\\;sG\u0016\u0014Vm]8mm\u0016\u0014(B\u0001\f\u0018\u0003\r\u0019Hm\u001b\u0006\u00031e\t!A\u001e\u001a\u000b\u0005iY\u0012!B<fCZ,'B\u0001\u000f\u001e\u0003\u0011iW\u000f\\3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&K\u0007\u0002+%\u0011!&\u0006\u0002\u0016/\u0016\fg/\u001a*fg>,(oY3SKN|GN^3s\u00031\u0019G.Y:tY>\fG-\u001a:t!\riS\u0007\u000f\b\u0003]Mr!a\f\u001a\u000e\u0003AR!!M\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u0001\u001b$\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\u0007M+\u0017O\u0003\u00025GA\u0019!%O\u001e\n\u0005i\u001a#!\u0003$v]\u000e$\u0018n\u001c81!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0003mC:<'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u00121b\u00117bgNdu.\u00193fe\u00061A(\u001b8jiz\"\"!\u0012$\u0011\u0005!\u0002\u0001\"B\u0016\u0003\u0001\u0004a\u0013a\u0002:fg>dg/\u001a\u000b\u0003\u0013>\u00032A\t&M\u0013\tY5E\u0001\u0004PaRLwN\u001c\t\u0003Q5K!AT\u000b\u0003\u001b]+\u0017M^3SKN|WO]2f\u0011\u0015\u00016\u00011\u0001R\u0003\u0011q\u0017-\\3\u0011\u0005IKV\"A*\u000b\u0005Q+\u0016!\u0003<be&\f'\r\\3t\u0015\t1v+A\u0002bgRT!\u0001W\f\u0002\rA\f'o]3s\u0013\tQ6K\u0001\bOC6,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u001bI,7o\u001c7wK\nKg.\u0019:z)\ti\u0016\rE\u0002#\u0015z\u0003\"\u0001K0\n\u0005\u0001,\"a\u0005\"j]\u0006\u0014\u0018pV3bm\u0016\u0014Vm]8ve\u000e,\u0007\"\u0002)\u0005\u0001\u0004\t\u0016a\u0003:fg>dg/\u001a)bi\"$\"!\u00133\t\u000b\u0015,\u0001\u0019\u00014\u0002\tA\fG\u000f\u001b\t\u0003O.t!\u0001[5\u0011\u0005=\u001a\u0013B\u00016$\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)\u001c\u0013!\u0005:fg>dg/\u001a\"j]\u0006\u0014\u0018\u0010U1uQR\u0011Q\f\u001d\u0005\u0006K\u001a\u0001\rAZ\u0001\u0016i><V-\u0019<f'>,(oY3SKN|WO]2f)\t\u0019h\u000f\u0005\u0002)i&\u0011Q/\u0006\u0002\u0015\t\u00164\u0017-\u001e7u/\u0016\fg/\u001a*fg>,(oY3\t\u000b]<\u0001\u0019\u0001=\u0002\u000f\u0015dW-\\3oiB\u0011\u0011\u0010`\u0007\u0002u*\u00111pP\u0001\u0004]\u0016$\u0018BA?{\u0005\r)&\u000bT\u0001\u0016i><V-\u0019<f\u0005&t\u0017M]=SKN|WO]2f)\u0015q\u0016\u0011AA\u0002\u0011\u00159\b\u00021\u0001y\u0011\u0019\t)\u0001\u0003a\u0001\u0019\u0006\u00192o\\;sG\u0016<V-\u0019<f%\u0016\u001cx.\u001e:dK\u0006Q!/Z:pYZ,WK\u001d7\u0015\t\u0005-\u0011Q\u0002\t\u0004E)C\b\"B3\n\u0001\u00041\u0017A\u0003:fg>dg/Z!mYR!\u00111CA\u000b!\riS\u0007\u0014\u0005\u0006!*\u0001\r!U\u0001\u0010Y>|7.\u001e9SKN|WO]2fgR!\u00111CA\u000e\u0011\u0015)7\u00021\u0001g\u0003I\u0019\u0017M\u001c*fg>dg/\u001a*fg>,(oY3\u0015\t\u0005\u0005\u0012q\u0005\t\u0004E\u0005\r\u0012bAA\u0013G\t9!i\\8mK\u0006t\u0007\"\u0002)\r\u0001\u0004\t\u0016\u0001I\"mCN\u001cHj\\1eKJ<V-\u0019<f%\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ\u0004\"\u0001\u000b\b\u0014\u00059\tCCAA\u0016\u0003\u0015\t\u0007\u000f\u001d7z)\u0005)\u0015\u0001\u00068p\u0007>tG/\u001a=u\u00072\f7o\u001d7pC\u0012,'/\u0001\fd_:$X\r\u001f;DY\u0006\u001c8\u000f\\8bI\u0016\u0014xJ\u001c7z\u0003M\u0001(o\u001c<jI\u0016$7\t\\1tg2{\u0017\rZ3s)\r)\u0015Q\b\u0005\b\u0003\u007f\u0019\u0002\u0019AA!\u00031\u0019G.Y:t\u0019>\fG-\u001a:t!\riSg\u000f")
public class ClassLoaderWeaveResourceResolver
implements WeaveResourceResolver {
    private final Seq<Function0<ClassLoader>> classloaders;

    public static ClassLoaderWeaveResourceResolver providedClassLoader(Seq<ClassLoader> seq) {
        return ClassLoaderWeaveResourceResolver$.MODULE$.providedClassLoader(seq);
    }

    public static ClassLoaderWeaveResourceResolver contextClassloaderOnly() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.contextClassloaderOnly();
    }

    public static ClassLoaderWeaveResourceResolver noContextClassloader() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.noContextClassloader();
    }

    public static ClassLoaderWeaveResourceResolver apply() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.apply();
    }

    @Override
    public Option<WeaveResource> resolve(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.resolvePath(path);
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinary(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveBinaryFilePath(name, "/");
        return this.resolveBinaryPath(path);
    }

    @Override
    public Option<WeaveResource> resolvePath(String path) {
        return this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinaryPath(String path) {
        Option maybeSourceWeaveResource = this.resolveUrl(path.replace(WeaveFile$.MODULE$.binaryFileExtension(), WeaveFile$.MODULE$.fileExtension())).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
        return maybeSourceWeaveResource.flatMap((Function1 & Serializable & scala.Serializable)sourceWeaveResource -> this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveBinaryResource((URL)url, (WeaveResource)sourceWeaveResource)));
    }

    private DefaultWeaveResource toWeaveSourceResource(URL element) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(element.openStream(), WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(element.toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    private BinaryWeaveResource toWeaveBinaryResource(URL element, WeaveResource sourceWeaveResource) {
        return WeaveResourceFactory$.MODULE$.fromBinaryInputStream(element.openStream(), sourceWeaveResource);
    }

    public Option<URL> resolveUrl(String path) {
        String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        while (classLoadersIt.hasNext() && !resources.hasMoreElements()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
        }
        if (resources.hasMoreElements()) {
            return Option$.MODULE$.apply(resources.nextElement());
        }
        return None$.MODULE$;
    }

    @Override
    public Seq<WeaveResource> resolveAll(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.lookupResources(path);
    }

    public Seq<WeaveResource> lookupResources(String path) {
        String weaveFilePath = path.startsWith("/") ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (classLoadersIt.hasNext()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
            result.$plus$plus$eq((TraversableOnce)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(resources).asScala()).map((Function1 & Serializable & scala.Serializable)resource -> {
                DefaultWeaveResource defaultWeaveResource;
                try (BufferedSource source = Source$.MODULE$.fromInputStream(resource.openStream(), "UTF-8");){
                    defaultWeaveResource = WeaveResource$.MODULE$.apply(resource.toExternalForm(), source.mkString());
                }
                return defaultWeaveResource;
            }));
        }
        return result;
    }

    @Override
    public boolean canResolveResource(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, "/");
        return this.resolveUrl(path).isDefined();
    }

    public ClassLoaderWeaveResourceResolver(Seq<Function0<ClassLoader>> classloaders) {
        this.classloaders = classloaders;
        WeaveResourceResolver.$init$(this);
    }
}

