package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.PreCompiledTypeAnnotation
import org.mule.weave.v2.parser.ast.module.ModuleNode

class ModuleAstCloningPhase extends CompilationPhase[ScopeGraphResult[ModuleNode], ScopeGraphResult[ModuleNode]] {

  override def doCall(source: ScopeGraphResult[ModuleNode], ctx: ParsingContext): PhaseResult[_ <: ScopeGraphResult[ModuleNode]] = {
    if (!source.astNode.isAnnotatedWith(classOf[PreCompiledTypeAnnotation])) {
      val clonedAst: ModuleNode = source.astNode.cloneAst().asInstanceOf[ModuleNode]
      val scopeGraphPhase = new ScopeGraphPhase[ModuleNode]()
      scopeGraphPhase.call(new ScopeGraphResult(source.input, clonedAst, source.scope), ctx)
    } else {
      SuccessResult(source, ctx)
    }
  }
}
