package org.mule.weave.v2.editor.quickfix

import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.editor.QuickFixAction
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.utils.WeaveTypeHelper

class InsertDefaultQuickFix(val expectedType: WeaveType, val actualType: WeaveType, val argumentLocation: WeaveLocation) extends QuickFixAction {
  override def run(document: WeaveTextDocument): Unit = {
    val startIndex = argumentLocation.startPosition.index
    val endIndex = argumentLocation.endPosition.index
    val argumentText = document.text(startIndex, endIndex)
    document.delete(startIndex, endIndex)
    document.runTemplate(Template().add("(").add(argumentText).add(" default ").placeHolder(WeaveTypeHelper.createDefaultValueExpression(expectedType)).add(")"), startIndex)
  }

  def canEqual(other: Any): Boolean = other.isInstanceOf[InsertDefaultQuickFix]

  override def equals(other: Any): Boolean = other match {
    case that: InsertDefaultQuickFix =>
      (that canEqual this) &&
        expectedType == that.expectedType &&
        actualType == that.actualType &&
        argumentLocation == that.argumentLocation
    case _ => false
  }

  override def hashCode(): Int = {
    val state = Seq(expectedType, actualType, argumentLocation)
    state.map(_.hashCode()).foldLeft(0)((a, b) => 31 * a + b)
  }
}