package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import java.io.{ PrintWriter, Writer }
import scala.collection.mutable

class CompilationPhaseMetrics(val nameIdentifier: NameIdentifier, val parent: Option[CompilationPhaseMetrics], val indent: Int = 0) {

  val compilation: TimeMetric = new TimeMetric()
  var fromBinary: Option[Boolean] = None
  var cached: Boolean = false
  private val children: mutable.ArrayBuffer[CompilationPhaseMetrics] = mutable.ArrayBuffer[CompilationPhaseMetrics]()

  def print(): Unit = {
    print(new PrintWriter(System.out))
  }

  def print(writer: Writer): Unit = {
    writer.write(s"|${"--|" * indent}[${nameIdentifier}] took ${compilation.duration()} ms [cached: ${cached}${fromBinary.map(v => s", fromBinary: ${v}").getOrElse("")}]")
    children.foreach((c) => {
      c.print(writer)
    })
  }

  def child(nameIdentifier: NameIdentifier): CompilationPhaseMetrics = {
    val metric = new CompilationPhaseMetrics(nameIdentifier, Some(this), indent + 1)
    children.+=(metric)
    metric
  }

  def childrenMetrics(): Array[CompilationPhaseMetrics] = {
    children.toArray
  }

  def startCompilation(): Unit = {
    compilation.start()
  }

  def endCompilation(cached: Boolean, fromBinary: Option[Boolean]): Unit = {
    compilation.end()
    this.cached = cached
    this.fromBinary = fromBinary
  }
}
