package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.CompilationPhase

import java.io.{ PrintWriter, Writer }
import scala.collection.mutable

class ParsingPhaseMetric(val nameIdentifier: NameIdentifier, val phase: CompilationPhase[_, _], val parent: Option[ParsingPhaseMetric], val indent: Int = 0) {
  val timeMetric: TimeMetric = new TimeMetric();
  private val children: mutable.ArrayBuffer[ParsingPhaseMetric] = mutable.ArrayBuffer[ParsingPhaseMetric]()

  def child(nameIdentifier: NameIdentifier, phase: CompilationPhase[_, _]): ParsingPhaseMetric = {
    val metric = new ParsingPhaseMetric(nameIdentifier, phase, Some(this), indent + 1)
    children.+=(metric)
    metric
  }

  def childrenMetrics(): Array[ParsingPhaseMetric] = {
    children.toArray
  }

  def startPhase(): Unit = {
    timeMetric.start()
  }

  def endPhase(): Option[ParsingPhaseMetric] = {
    timeMetric.end()
    parent
  }

  def print(): Unit = {
    print(new PrintWriter(System.out))
  }

  def print(writer: Writer): Unit = {
    writer.write(s"|${"--|" * indent}[${nameIdentifier}] - [${phase.getClass.getSimpleName}] took ${timeMetric.duration()}ms")
    children.foreach((c) => {
      c.print(writer)
    })
  }
}
