package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ParameterIsNotStreamCapable
import org.mule.weave.v2.parser.annotation.StreamingCapableVariableAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.functions.FunctionParameter
import org.mule.weave.v2.parser.ast.header.directives.InputDirective
import org.mule.weave.v2.parser.ast.header.directives.VarDirective

/**
  * Validates that a given "variable" can be streamed. By variable we mean a function parameter or an input or a variable definition
  */
class StreamValidatorAnnotationProcessor extends AbstractScopeAnnotationProcessor {

  override def run(annotatedNode: AstNode, annotation: AnnotationNode, context: ScopePhaseAnnotationContext): Unit = {
    annotatedNode match {
      case fpn: FunctionParameter => {
        val mayBeAnnotation = fpn.variable.annotation(classOf[StreamingCapableVariableAnnotation])
        mayBeAnnotation match {
          case Some(streamingAnnotation) => {
            if (!streamingAnnotation.canStream) {
              context.messageCollector.error(ParameterIsNotStreamCapable(fpn.variable, streamingAnnotation.reasons), fpn.variable.location())
            }
          }
          case _ =>
        }
      }
      case fpn: VarDirective => {
        val mayBeAnnotation = fpn.variable.annotation(classOf[StreamingCapableVariableAnnotation])
        mayBeAnnotation match {
          case Some(streamingAnnotation) => {
            if (!streamingAnnotation.canStream) {
              context.messageCollector.error(ParameterIsNotStreamCapable(fpn.variable, streamingAnnotation.reasons), fpn.variable.location())
            }
          }
          case _ =>
        }
      }
      case fpn: InputDirective => {
        val mayBeAnnotation = fpn.variable.annotation(classOf[StreamingCapableVariableAnnotation])
        mayBeAnnotation match {
          case Some(streamingAnnotation) => {
            if (!streamingAnnotation.canStream) {
              context.messageCollector.error(ParameterIsNotStreamCapable(fpn.variable, streamingAnnotation.reasons), fpn.variable.location())
            }
          }
          case _ =>
        }
      }
      case _ =>
    }
  }

}
