package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.scope.{ AstNavigator, ScopesNavigator }

/**
  * This phase applies scope resolution
  *
  * @tparam T the ast node type
  */
class ScopeGraphPhase[T <: AstNode] extends CompilationPhase[AstNodeResultAware[T] with ParsingContentAware, ScopeGraphResult[T]] {

  override def doCall(node: AstNodeResultAware[T] with ParsingContentAware, ctx: ParsingContext): PhaseResult[ScopeGraphResult[T]] = {
    val navigator: ScopesNavigator = ScopesNavigator(node.astNode, ctx)
    SuccessResult(new ScopeGraphResult(node.input, node.astNode, navigator), ctx)
  }

}

object ScopeGraphPhase {
  def apply[T <: AstNode](): CompilationPhase[AstNodeResultAware[T] with ParsingContentAware, ScopeGraphResult[T]] = {
    new ScopeGraphPhase[T]()
      .enrichWith(new ImportsValidation[T, ScopeGraphResult[T]]()) // First check imports, if not found fails...
      .enrichWith(new ReferencesValidation[T, ScopeGraphResult[T]]())
      .enrichWith(new ForwardReferenceValidationPhase[T]())
      .enrichWith(new TypeParameterCheckerPhase[T]())
  }
}

trait ScopeNavigatorResultAware extends AstNavigatorResultAware {
  def scope: ScopesNavigator

  override def astNavigator: AstNavigator = scope.astNavigator()
}

trait AstNavigatorResultAware {
  def astNavigator: AstNavigator
}

class ScopeGraphResult[T <: AstNode](_input: ParsingContentInput, _astNode: T, val scope: ScopesNavigator) extends ParsingResult[T](_input, _astNode) with ScopeNavigatorResultAware with AstNodeResultAware[T]

object ScopeGraphResult {
  def unapply[T <: AstNode](result: ScopeGraphResult[T]): Option[(ParsingContentInput, T, ScopesNavigator)] = {
    Some((result.input, result.astNode, result.scope))
  }
}