package org.mule.weave.v2.parser.phase.metrics

import java.io.{ PrintWriter, Writer }

class CompilationMetrics(val parsingMetrics: Array[ParsingPhaseMetric], val compilationMetrics: Array[CompilationPhaseMetrics], val resourceMetrics: Array[ResourceMetrics]) {

  def print(): Unit = {
    print(new PrintWriter(System.out))
  }

  def print(writer: Writer): Unit = {
    writer.write("====================== Resource Metrics ======================\n")
    Option(resourceMetrics).getOrElse(Array.empty[ResourceMetrics]).foreach((p) => p.print(writer))
    writer.write("====================== Parsing Phases Metrics ======================\n")
    Option(parsingMetrics).getOrElse(Array.empty[ParsingPhaseMetric]).foreach((p) => p.print(writer))
    writer.write("====================== Compilation Phase Metrics ======================\n")
    Option(compilationMetrics).getOrElse(Array.empty[CompilationPhaseMetrics]).foreach((p) => p.print(writer))
    writer.flush()
  }
}
