package org.mule.weave.v2.parser.annotation

case class DataFormatExtensionAnnotation(dataFormatSetting: DataFormatSettings) extends WithValueAstNodeAnnotation[DataFormatSettings] {
  override def name(): String = "dataFormatExtension"

  override def value(): DataFormatSettings = dataFormatSetting
}

case class DataFormatSettings(readerSettings: Seq[DataFormatSetting[_]], writerSettings: Seq[DataFormatSetting[_]])

trait DataFormatSetting[T] {
  def name: String
  def defaultValue: T
  def possibleValues: Seq[T] = Seq.empty
}

case class StringSetting(name: String, defaultValue: String, override val possibleValues: Seq[String] = Seq.empty) extends DataFormatSetting[String]
case class BooleanSetting(name: String, defaultValue: Boolean = false) extends DataFormatSetting[Boolean]
case class IntSetting(name: String, defaultValue: Int) extends DataFormatSetting[Int]