package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.NullType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

import scala.collection.Seq

object NullSafeTypeResolver extends WeaveTypeResolver {

  def isUnionOfOptional(weaveType: WeaveType): Boolean = {
    weaveType match {
      case ut: UnionType => ut.of.exists(_.isOptional())
      case _             => false
    }
  }

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val weaveType: WeaveType = node.incomingTypes().head
    if (weaveType.isOptional() || isUnionOfOptional(weaveType)) {
      Some(TypeHelper.unify(Seq(weaveType, NullType())))
    } else {
      Some(weaveType)
    }
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    if (incomingExpectedType.isDefined) {
      node.incomingEdges().map((_, incomingExpectedType.get))
    } else {
      Seq()
    }
  }
}
