package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ModuleLoader
import org.mule.weave.v2.sdk.EmptyWeaveResourceResolver
import org.mule.weave.v2.sdk.WeaveResourceResolver
import org.mule.weave.v2.utils.WeaveFile

import java.io.{ PrintWriter, Writer }

class ResourceMetrics(val nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver) {
  val time: TimeMetric = new TimeMetric();
  var size: Int = 0

  def startFetch(): Unit = {
    time.start()
  }

  def endFetch(size: Int): Unit = {
    this.size = size
    time.end()
  }

  def print(): Unit = {
    print(new PrintWriter(System.out))
  }

  def print(writer: Writer): Unit = {
    val safeNameIdentifier = Option(nameIdentifier).getOrElse(NameIdentifier("unknown", None))
    val safeResourceResolver = Option(resourceResolver).getOrElse(EmptyWeaveResourceResolver)
    val loader = safeNameIdentifier.loader.map(loader => s"[${loader}!").getOrElse(s"[${ModuleLoader.DEFAULT_LOADER_NAME}!")
    writer.write(s"|- ${loader}${safeNameIdentifier}] [${safeResourceResolver.getClass.getSimpleName}] took ${time.duration()}ms [size: ${size}]\n")
  }
}
