package org.mule.weave.v2.grammar.structure

import org.mule.weave.v2.grammar.Grammar
import org.mule.weave.v2.grammar.Tokens
import org.mule.weave.v2.grammar.literals.BaseExpression
import org.mule.weave.v2.grammar.location.PositionTracking
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.structure._
import org.parboiled2._

trait Attributes extends PositionTracking with Tokens with Namespaces with BaseExpression {
  this: Attributes with Grammar =>

  def expr: Rule1[AstNode]

  def attributes: Rule1[Option[AttributesNode]] = rule {
    (fws ~ fullAttributes | emptyAttributes)
  }

  def emptyAttributes: Rule1[Option[AttributesNode]] = rule {
    push(None)
  }

  def fullAttributes: Rule1[Option[AttributesNode]] = namedRule("Attribute<'@('(Name:Value)+')'>") {
    pushPosition ~ (attributesStart ~ zeroOrMore(attribute | conditionalAttribute | enclosedExpr).separatedBy(commaSep) ~ quiet(optional(commaSep)) ~ ws ~ attributesEnd ~> createAttributesNode) ~ injectPosition
  }

  val createAttributesNode: (Seq[AstNode]) => Some[AttributesNode] = (members: Seq[AstNode]) => {
    Some(AttributesNode(members))
  }

  def attributeName: Rule1[NameNode] = namedRule("`Valid Field Name`") {
    pushPosition ~ atomic(annotations ~ ws ~ (namespace ~ (nameString | string)) ~> createNameNode) ~ injectPosition
  }

  def attributeNameWithoutAnnotations: Rule1[NameNode] = namedRule("`Valid Field Name`") {
    pushPosition ~ atomic((namespace ~ (nameString | string)) ~> createNameNodeWithoutAnnotations) ~ injectPosition
  }

  def dynamicAttributeName: Rule1[AstNode] = rule {
    pushPosition ~ (enclosedExpr ~> createDynamicNameNode) ~ injectPosition
  }

  val createDynamicNameNode: (AstNode) => DynamicNameNode = (keyName: AstNode) => {
    DynamicNameNode(keyName)
  }

  def attribute: Rule1[NameValuePairNode] = rule {
    pushPosition ~ ((attributeName | dynamicAttributeName) ~ ws ~ objFieldSep ~!~ (expr | missingExpression("missing attribute value expression. i.e {a @(myAttr: true): 123 }")) ~> createNameValuePairNode) ~ injectPosition
  }

  private def conditionalAttribute = rule {
    pushPosition ~ (parenStart ~ ws ~ (attributeName | dynamicAttributeName) ~ objFieldSep ~!~ (expr | missingExpression("missing attribute value expression. i.e {a @((myAttr: true) if(1 > 2)): 123 }")) ~ parenEnd ~ ws ~ ifKeyword ~!~ ((ws ~ ifCondition) | (fws ~ (expr | missingExpression("missing conditional expression.")))) ~> createConditionalNameValuePairNode) ~ injectPosition
  }

  val createNameValuePairNode: (AstNode, AstNode) => NameValuePairNode = (key: AstNode, value: AstNode) => {
    NameValuePairNode(key, value)
  }

  val createConditionalNameValuePairNode: (AstNode, AstNode, AstNode) => NameValuePairNode = (key: AstNode, value: AstNode, cond: AstNode) => {
    NameValuePairNode(key, value, Some(cond))
  }

}
