package org.mule.weave.v2.inspector

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.phase.{ AstNodeResultAware, FullCompileOnlyPhase, ParsingContext, PhaseResult, ScopeNavigatorResultAware, SuccessResult }

class ScopeCodeInspectorPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware](inspectors: Seq[CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware]]) extends FullCompileOnlyPhase[R, T] {

  override def run(source: T, context: ParsingContext): Unit = {
    val rootNode: R = source.astNode
    AstNodeHelper.traverse(rootNode, (node) => {
      inspectors.foreach((inspector) => {
        inspector.inspect(node, source, context)
      })
      true
    })
  }
}
