package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.scope.ScopesNavigator

class NoValidationScopeGraphPhase[T <: AstNode] extends CompilationPhase[AstNodeResultAware[T] with ParsingContentAware, ScopeGraphResult[T]] {

  override def doCall(node: AstNodeResultAware[T] with ParsingContentAware, ctx: ParsingContext): PhaseResult[ScopeGraphResult[T]] = {
    val navigator: ScopesNavigator = ScopesNavigator(node.astNode, ctx)
    SuccessResult(new ScopeGraphResult(node.input, node.astNode, navigator), ctx)
  }

}
