package org.mule.weave.v2.editor.refactor

import org.mule.weave.v2.editor.CodeRefactor
import org.mule.weave.v2.editor.RefactorParameter
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.editor.refactor.ExtractFunctionRefactor.FUNCTION_NAME_PARAM_NAME
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.scope.VariableDependency

class ExtractFunctionRefactor(introduceDo: Boolean, insertSeparator: Boolean, insertIntoStringInterpolation: Boolean, extractExpression: WeaveLocation, placeToInsert: Int, scope: WeaveLocation, defaultName: String, functionParams: Seq[VariableDependency]) extends CodeRefactor {

  override def parameters(): Array[RefactorParameter] = Array(RefactorParameter(FUNCTION_NAME_PARAM_NAME, defaultName, "Function Name"))

  override def run(document: WeaveTextDocument, arguments: Map[String, Any]): Unit = {
    val variableName = arguments.getOrElse(FUNCTION_NAME_PARAM_NAME, "myFun").toString
    var newExpressionName = variableName + "(" + functionParams.map(_.name).mkString(",") + ")"

    if (insertIntoStringInterpolation) {
      newExpressionName = "\"$(" + newExpressionName + ")\""
    }
    if (introduceDo) {
      document.insert("\n}", scope.endPosition.index)
      val expressionText: String = document.text(extractExpression.startPosition.index, extractExpression.endPosition.index)
      //Replace old expression with new one
      document.replace(extractExpression.startPosition.index, extractExpression.endPosition.index, newExpressionName)

      val newExpression: String = s"do {\n\t${buildDirectiveContent(variableName, expressionText)}\n\t---\n"
      document.insert(newExpression, placeToInsert)
    } else {
      val expressionText: String = document.text(extractExpression.startPosition.index, extractExpression.endPosition.index)
      document.replace(extractExpression.startPosition.index, extractExpression.endPosition.index, newExpressionName)
      var newExpression: String = s"\n${buildDirectiveContent(variableName, expressionText)}\n"
      if (insertSeparator) {
        newExpression = newExpression + "---\n"
      }
      document.insert(newExpression, placeToInsert)
    }
  }

  private def buildDirectiveContent(variableName: String, expressionText: String): String = {
    s"fun ${variableName}(${functionParametersSignature()}) = ${expressionText}"
  }

  private def functionParametersSignature() = {
    functionParams
      .map((fp) => {
        fp.name +
          fp.weaveType
          .map((ft) => ":" + ft.toString(prettyPrint = false, namesOnly = true))
          .getOrElse("")
      })
      .mkString(",")
  }
}

object ExtractFunctionRefactor {
  val FUNCTION_NAME_PARAM_NAME = "functionName"
}
