package org.mule.weave.v2.parser.phase.metrics

import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ModuleLoader
import org.mule.weave.v2.sdk.WeaveResourceResolver
import org.mule.weave.v2.utils.WeaveFile

class ResourceMetrics(val nameIdentifier: NameIdentifier, resourceResolver: WeaveResourceResolver) {
  val time: TimeMetric = new TimeMetric();
  var size: Int = 0

  def startFetch(): Unit = {
    time.start()
  }

  def endFetch(size: Int): Unit = {
    this.size = size
    time.end()
  }

  def print(): Unit = {
    val loader = nameIdentifier.loader.map(loader => s"[${loader}!").getOrElse(s"[${ModuleLoader.DEFAULT_LOADER_NAME}")
    println(s"|- ${loader}${nameIdentifier}] [${resourceResolver.getClass.getSimpleName}] took ${time.duration()}ms [size: ${size}]")
  }
}
