package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.annotation.StaticFunctionBodyNodeAnnotation
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.FunctionNode
import org.mule.weave.v2.parser.ast.module.ModuleNode

class StaticFunctionMarkerPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends FullCompileOnlyPhase[R, T] {

  override def run(source: T, context: ParsingContext): Unit = {
    if (source.astNavigator.documentNode.isInstanceOf[ModuleNode]) {
      val functionNodes = source.scope.astNavigator().allWithType(classOf[FunctionNode])
      functionNodes.foreach(fn => {
        markStaticFunctionNodeBody(source, fn.body)
      })
    }
  }

  private def markStaticFunctionNodeBody(source: T, body: AstNode): Unit = {
    if (source.astNavigator.granGranParentOf(body).exists(_.isInstanceOf[ModuleNode])) {
      body.annotate(StaticFunctionBodyNodeAnnotation())
    }
  }
}
