package org.mule.weave.v2.parser.ast.functions

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Children
import org.mule.weave.v2.parser.ast.DirectivesCapableNode
import org.mule.weave.v2.parser.ast.ExpressionAstNode
import org.mule.weave.v2.parser.ast.MutableAstNode
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.DirectiveNode

/**
  * Do blocks can contain variable, function, namespace, type directives and a body, which is separated by --- when there are directives.
  * <br/>
  * For example:
  * <pre>
  * do {
  * var a = 1
  * var b = 2
  * fun foo(n) = a + b + n
  * ---
  * foo(3) // returns 6
  * }
  * </pre>
  */
case class DoBlockNode(header: HeaderNode, var body: AstNode, var codeAnnotations: Seq[AnnotationNode] = Seq()) extends ExpressionAstNode with DirectivesCapableNode with MutableAstNode {
  override def children(): Seq[AstNode] = Children(header, body).++=(codeAnnotations).result()

  override def directives: Seq[DirectiveNode] = header.directives

  override protected def doClone(): AstNode = {
    copy(header.cloneAst(), body.cloneAst(), codeAnnotations.map(_.cloneAst()))
  }

  /**
    * Sets the annotations to this node
    *
    * @param annotations The list of annotations
    */
  override def setAnnotations(annotations: Seq[AnnotationNode]): Unit = {
    this.codeAnnotations = annotations
  }

  override def getKind(): String = DWAstNodeKind.DO_BLOCK_NODE

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (body eq toBeReplaced) body = withNode
  }
}
