package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.DoBlockNode
import org.mule.weave.v2.parser.ast.header.directives.ImportDirective
import org.mule.weave.v2.parser.ast.module.ModuleNode
import org.mule.weave.v2.parser.ast.structure.DocumentNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.{ CyclicWeaveImport, InvalidReferenceMessage, MessageCollector, SelfImportingModule, UnableToResolveModule }

class ReferencesValidation[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware] extends VerificationPhase[R, T] {

  override def verify(source: T, context: ParsingContext): Unit = {
    val invalidRefs: Seq[AstNode] = source.scope.invalidReferences()
    invalidRefs.foreach((refNode) => {
      context.messageCollector.error(InvalidReferenceMessage(refNode), refNode.location())
    })
  }
}