package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.KeyValuePairType
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object SchemePropertyResolver extends WeaveTypeResolver {

  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val keyType = node.incomingEdges().head.incomingType()
    val valueType = node.incomingEdges()(1).incomingType()
    Some(KeyValuePairType(keyType, valueType))
  }
}
