package org.mule.weave.v2.ts.resolvers

import org.mule.weave.v2.ts.Edge
import org.mule.weave.v2.ts.NothingType
import org.mule.weave.v2.ts.NullType
import org.mule.weave.v2.ts.ReferenceType
import org.mule.weave.v2.ts.TypeHelper
import org.mule.weave.v2.ts.TypeNode
import org.mule.weave.v2.ts.UnionType
import org.mule.weave.v2.ts.WeaveType
import org.mule.weave.v2.ts.WeaveTypeResolutionContext
import org.mule.weave.v2.ts.WeaveTypeResolver

object NullUnSafeTypeResolver extends WeaveTypeResolver {
  override def resolveReturnType(node: TypeNode, ctx: WeaveTypeResolutionContext): Option[WeaveType] = {
    val weaveType = node.incomingTypes().head
    doResolve(weaveType)
  }

  override def resolveExpectedType(node: TypeNode, incomingExpectedType: Option[WeaveType], ctx: WeaveTypeResolutionContext): Seq[(Edge, WeaveType)] = {
    if (incomingExpectedType.isDefined) {
      node.incomingEdges().map((_, incomingExpectedType.get))
    } else {
      Seq()
    }
  }

  private def doResolve(weaveType: WeaveType): Option[WeaveType] = {
    weaveType match {
      case UnionType(of) => {
        val types = of.filterNot({
          case n: NullType => n.isSelectionMissed()
          case _           => false
        })
        if (types.isEmpty) {
          Some(NothingType())
        } else {
          Some(TypeHelper.unify(types))
        }
      }
      case referenceType: ReferenceType => doResolve(referenceType.resolveType())
      case _                            => Some(weaveType)
    }
  }
}
