package org.mule.weave.v2.parser.annotation

/**
  * Annotation used by the AST Serializer to annotate modules that were loaded from its binary pre-compiled file.
  * It is used in different phases of the compilation to avoid execution of passes that were already done when
  * the module was pre-compiled.
  *
  * @since 2.10
  */
case class PreCompiledTypeAnnotation() extends AstNodeAnnotation with EphemeralAstNodeAnnotation {
  override def name(): String = "PreCompiledTypeAnnotation"
}
