package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode

/**
  * These transformations will modify the AST and will not be applied later to a preCompiled script as links to these
  * nodes are already in place and cannot be changed. [[AstNodeTransformer]] would allow to modify by overwriting values from
  * context. For instance, an input or output could be later changed using Bindings.
  */
class AstNodeTransformationPhase[R <: AstNode, T <: AstNodeResultAware[R]](transformers: Array[AstNodeTransformer]) extends FullCompileOnlyPhase[R, T] {

  override def run(source: T, context: ParsingContext): Unit = {
    traverse(source.astNode, context)
    SuccessResult(source, context)
  }

  private def traverse(node: AstNode, ctx: ParsingContext): Unit = {
    doTransform(node, ctx)
    val nodes = node.children()
    var i = 0
    while (i < nodes.length) {
      traverse(nodes(i), ctx)
      i = i + 1
    }
  }

  private def doTransform(node: AstNode, ctx: ParsingContext): Unit = {
    var i = 0
    while (i < transformers.length) {
      transformers(i).transform(node, ctx)
      i = i + 1
    }
  }

}
