package org.mule.weave.v2.inspector

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.editor.QuickFixAction
import org.mule.weave.v2.editor.WeaveTextDocument
import org.mule.weave.v2.parser.ReplaceUsingWithDo
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.functions.DoBlockNode
import org.mule.weave.v2.parser.ast.functions.UsingNode
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware

object ReplaceUsingWithDoInspector extends CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware] {

  override def inspect(node: AstNode, scopeData: AstNodeResultAware[_] with ScopeNavigatorResultAware, parsingContext: ParsingContext): Unit = {
    node match {
      case un @ UsingNode(_, _, _) => {
        parsingContext.messageCollector.warning(ReplaceUsingWithDo(un), node.location())
      }
      case _ =>
    }
  }
}

class ReplaceUsingWithDoFixAction(usingNode: UsingNode) extends QuickFixAction {

  override def run(document: WeaveTextDocument): Unit = {
    val directives = usingNode.assignments.assignmentSeq.map(assignment => {
      VarDirective(assignment.name, assignment.value)
    })
    val doBlock = DoBlockNode(new HeaderNode(directives), usingNode.expr)

    val startIndex = usingNode.location().startPosition.index
    document.replace(startIndex, usingNode.location().endPosition.index, CodeGenerator.generate(doBlock))
  }
}
