package org.mule.weave.v2.sdk

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.parser.module.ModuleLoaderProvider

import java.util.ServiceLoader
import org.mule.weave.v2.parser.phase.ModuleLoader

import scala.collection.JavaConversions._

@WeaveApi(Seq("data-weave-agent"))
class SPIBasedModuleLoaderProvider(weaveResourceResolver: WeaveResourceResolver) extends ModuleLoaderProvider {

  val additionalModules: Seq[ModuleLoader] = loadModules()

  private def loadModules(): Seq[ModuleLoader] = {
    val modules = ServiceLoader.load(classOf[ModuleLoader], classOf[ModuleLoader].getClassLoader).iterator().toSeq
    modules.foreach({
      case rra: WeaveResourceResolverAware => rra.resolver(weaveResourceResolver)
      case _                               =>
    })
    modules
  }

  override def getModules: Seq[ModuleLoader] = {
    additionalModules
  }
}

object SPIBasedModuleLoaderProvider extends SPIBasedModuleLoaderProvider(ClassLoaderWeaveResourceResolver()) {
  def apply(weaveResourceResolver: WeaveResourceResolver): SPIBasedModuleLoaderProvider = new SPIBasedModuleLoaderProvider(weaveResourceResolver)

  // Add a deprecation warning for the singleton usage. We will keep the Singleton due to data-weave-agent is still using it, and we have
  // to support the same code with previous and new versions of DW.
  @deprecated("Use SPIBasedModuleLoaderProvider(weaveResourceResolver) instead of accessing the singleton directly. This singleton will be removed in a future version.")
  override def getModules: Seq[ModuleLoader] = super.getModules
}

/**
  * Marks ModuleLoader to require ResourceResolver
  */
trait WeaveResourceResolverAware {
  def resolver(resolver: WeaveResourceResolver): Unit
}
