package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.scope.ScopesNavigator

class DummyScopesNavigatorPhases[T <: AstNode] extends CompilationPhase[AstNodeResultAware[T] with ParsingContentAware, ParsingResultWithDummyScopeNavigator[T]] {
  override def doCall(source: AstNodeResultAware[T] with ParsingContentAware, context: ParsingContext): PhaseResult[_ <: ParsingResultWithDummyScopeNavigator[T]] = {
    SuccessResult(new ParsingResultWithDummyScopeNavigator(source.input, source.astNode, () => ScopesNavigator(source.astNode, context)), context)
  }
}

