/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.sdk;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.BinaryWeaveResource;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.DefaultWeaveResource;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.mule.weave.v2.utils.WeaveConstants$;
import org.mule.weave.v2.utils.WeaveFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ec\u0001B\f\u0019\u0001\rB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006=\u0002!\te\u0018\u0005\u0006K\u0002!\tE\u001a\u0005\u0006c\u0002!\tE\u001d\u0005\u0006i\u0002!I!\u001e\u0005\u0006}\u0002!Ia \u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!a\u0007\u0001\t\u0003\ni\u0002C\u0004\u0002$\u0001!\t!!\n\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,\u001d9\u0011Q\u0007\r\t\u0002\u0005]bAB\f\u0019\u0011\u0003\tI\u0004\u0003\u0004G\u001f\u0011\u0005\u00111\b\u0005\n\u0003{y!\u0019!C\u0001\u0003\u007fA\u0001\"!\u0012\u0010A\u0003%\u0011\u0011\t\u0005\b\u0003\u000fzA\u0011AA%\u0011\u001d\tYe\u0004C\u0001\u0003\u0013Bq!!\u0014\u0010\t\u0003\tI\u0005C\u0004\u0002P=!\t!!\u0015\u0003A\rc\u0017m]:M_\u0006$WM],fCZ,'+Z:pkJ\u001cWMU3t_24XM\u001d\u0006\u00033i\t1a\u001d3l\u0015\tYB$\u0001\u0002we)\u0011QDH\u0001\u0006o\u0016\fg/\u001a\u0006\u0003?\u0001\nA!\\;mK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016-\u001b\u0005A\u0012BA\u0017\u0019\u0005U9V-\u0019<f%\u0016\u001cx.\u001e:dKJ+7o\u001c7wKJ\fAb\u00197bgNdw.\u00193feN\u00042\u0001\r\u001d<\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u00025E\u00051AH]8pizJ\u0011aJ\u0005\u0003o\u0019\nq\u0001]1dW\u0006<W-\u0003\u0002:u\t\u00191+Z9\u000b\u0005]2\u0003cA\u0013=}%\u0011QH\n\u0002\n\rVt7\r^5p]B\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005IA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0002I\u0013B\u00111\u0006\u0001\u0005\u0006]\t\u0001\raL\u0001\be\u0016\u001cx\u000e\u001c<f)\ta%\u000bE\u0002&\u001b>K!A\u0014\u0014\u0003\r=\u0003H/[8o!\tY\u0003+\u0003\u0002R1\tiq+Z1wKJ+7o\\;sG\u0016DQaU\u0002A\u0002Q\u000bAA\\1nKB\u0011Q\u000bX\u0007\u0002-*\u0011q\u000bW\u0001\nm\u0006\u0014\u0018.\u00192mKNT!!\u0017.\u0002\u0007\u0005\u001cHO\u0003\u0002\\5\u00051\u0001/\u0019:tKJL!!\u0018,\u0003\u001d9\u000bW.Z%eK:$\u0018NZ5fe\u0006i!/Z:pYZ,')\u001b8bef$\"\u0001\u00193\u0011\u0007\u0015j\u0015\r\u0005\u0002,E&\u00111\r\u0007\u0002\u0014\u0005&t\u0017M]=XK\u00064XMU3t_V\u00148-\u001a\u0005\u0006'\u0012\u0001\r\u0001V\u0001\fe\u0016\u001cx\u000e\u001c<f!\u0006$\b\u000e\u0006\u0002MO\")\u0001.\u0002a\u0001S\u0006!\u0001/\u0019;i!\tQgN\u0004\u0002lYB\u0011!GJ\u0005\u0003[\u001a\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011QNJ\u0001\u0012e\u0016\u001cx\u000e\u001c<f\u0005&t\u0017M]=QCRDGC\u00011t\u0011\u0015Ag\u00011\u0001j\u0003e!x\u000eT1{s^+\u0017M^3T_V\u00148-\u001a*fg>,(oY3\u0015\u0005=3\b\"B<\b\u0001\u0004A\u0018aB3mK6,g\u000e\u001e\t\u0003srl\u0011A\u001f\u0006\u0003w\n\u000b1A\\3u\u0013\ti(PA\u0002V%2\u000bQ\u0003^8XK\u00064XmU8ve\u000e,'+Z:pkJ\u001cW\r\u0006\u0003\u0002\u0002\u0005\u001d\u0001cA\u0016\u0002\u0004%\u0019\u0011Q\u0001\r\u0003)\u0011+g-Y;mi^+\u0017M^3SKN|WO]2f\u0011\u00159\b\u00021\u0001y\u0003U!xnV3bm\u0016\u0014\u0015N\\1ssJ+7o\\;sG\u0016$R!YA\u0007\u0003\u001fAQa^\u0005A\u0002aDa!!\u0005\n\u0001\u0004y\u0015aE:pkJ\u001cWmV3bm\u0016\u0014Vm]8ve\u000e,\u0017A\u0003:fg>dg/Z+sYR!\u0011qCA\r!\r)S\n\u001f\u0005\u0006Q*\u0001\r![\u0001\u000be\u0016\u001cx\u000e\u001c<f\u00032dG\u0003BA\u0010\u0003C\u00012\u0001\r\u001dP\u0011\u0015\u00196\u00021\u0001U\u0003=awn\\6vaJ+7o\\;sG\u0016\u001cH\u0003BA\u0010\u0003OAQ\u0001\u001b\u0007A\u0002%\f!cY1o%\u0016\u001cx\u000e\u001c<f%\u0016\u001cx.\u001e:dKR!\u0011QFA\u001a!\r)\u0013qF\u0005\u0004\u0003c1#a\u0002\"p_2,\u0017M\u001c\u0005\u0006'6\u0001\r\u0001V\u0001!\u00072\f7o\u001d'pC\u0012,'oV3bm\u0016\u0014Vm]8ve\u000e,'+Z:pYZ,'\u000f\u0005\u0002,\u001fM\u0011q\u0002\n\u000b\u0003\u0003o\ta\u0002U!U\u0011~\u001bV\tU!S\u0003R{%+\u0006\u0002\u0002BA\u0019q(a\u0011\n\u0005=\u0004\u0015a\u0004)B)\"{6+\u0012)B%\u0006#vJ\u0015\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0003!\u000bAC\\8D_:$X\r\u001f;DY\u0006\u001c8\u000f\\8bI\u0016\u0014\u0018AF2p]R,\u0007\u0010^\"mCN\u001cHn\\1eKJ|e\u000e\\=\u0002'A\u0014xN^5eK\u0012\u001cE.Y:t\u0019>\fG-\u001a:\u0015\u0007!\u000b\u0019\u0006C\u0004\u0002VY\u0001\r!a\u0016\u0002\u0019\rd\u0017m]:M_\u0006$WM]:\u0011\u0007ABd\b")
public class ClassLoaderWeaveResourceResolver
implements WeaveResourceResolver {
    private final Seq<Function0<ClassLoader>> classloaders;

    public static ClassLoaderWeaveResourceResolver providedClassLoader(Seq<ClassLoader> seq) {
        return ClassLoaderWeaveResourceResolver$.MODULE$.providedClassLoader(seq);
    }

    public static ClassLoaderWeaveResourceResolver contextClassloaderOnly() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.contextClassloaderOnly();
    }

    public static ClassLoaderWeaveResourceResolver noContextClassloader() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.noContextClassloader();
    }

    public static ClassLoaderWeaveResourceResolver apply() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.apply();
    }

    public static String PATH_SEPARATOR() {
        return ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR();
    }

    @Override
    public Option<WeaveResource> resolve(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.resolvePath(path);
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinary(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveBinaryFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.resolveBinaryPath(path);
    }

    @Override
    public Option<WeaveResource> resolvePath(String path) {
        return this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveSourceResource((URL)url));
    }

    @Override
    public Option<BinaryWeaveResource> resolveBinaryPath(String path) {
        Option maybeSourceWeaveResource = this.resolveUrl(path.replace(WeaveFile$.MODULE$.binaryFileExtension(), WeaveFile$.MODULE$.fileExtension())).map((Function1 & Serializable & scala.Serializable)url -> this.toLazyWeaveSourceResource((URL)url));
        return maybeSourceWeaveResource.flatMap((Function1 & Serializable & scala.Serializable)sourceWeaveResource -> this.resolveUrl(path).map((Function1 & Serializable & scala.Serializable)url -> this.toWeaveBinaryResource((URL)url, (WeaveResource)sourceWeaveResource)));
    }

    private WeaveResource toLazyWeaveSourceResource(URL element) {
        return WeaveResourceFactory$.MODULE$.lazyWeaveResource(element.toExternalForm(), (Function0<WeaveResource>)(Function0 & Serializable & scala.Serializable)() -> {
            DefaultWeaveResource defaultWeaveResource;
            try (BufferedSource source = Source$.MODULE$.fromInputStream(element.openStream(), WeaveConstants$.MODULE$.default_encoding());){
                defaultWeaveResource = WeaveResource$.MODULE$.apply(element.toExternalForm(), source.mkString());
            }
            return defaultWeaveResource;
        });
    }

    private DefaultWeaveResource toWeaveSourceResource(URL element) {
        DefaultWeaveResource defaultWeaveResource;
        try (BufferedSource source = Source$.MODULE$.fromInputStream(element.openStream(), WeaveConstants$.MODULE$.default_encoding());){
            defaultWeaveResource = WeaveResource$.MODULE$.apply(element.toExternalForm(), source.mkString());
        }
        return defaultWeaveResource;
    }

    private BinaryWeaveResource toWeaveBinaryResource(URL element, WeaveResource sourceWeaveResource) {
        return WeaveResourceFactory$.MODULE$.fromBinaryInputStream(element.openStream(), sourceWeaveResource);
    }

    public Option<URL> resolveUrl(String path) {
        String string = NameIdentifierHelper$.MODULE$.fileSeparator();
        String string2 = ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR();
        String cannonicalPath = (string == null ? string2 != null : !string.equals(string2)) ? path.replace(NameIdentifierHelper$.MODULE$.fileSeparator(), ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR()) : path;
        String weaveFilePath = cannonicalPath.startsWith(ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR()) ? cannonicalPath.substring(1) : cannonicalPath;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        while (classLoadersIt.hasNext() && !resources.hasMoreElements()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
        }
        if (resources.hasMoreElements()) {
            return Option$.MODULE$.apply(resources.nextElement());
        }
        return None$.MODULE$;
    }

    @Override
    public Seq<WeaveResource> resolveAll(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.lookupResources(path);
    }

    public Seq<WeaveResource> lookupResources(String path) {
        String weaveFilePath = path.startsWith(ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR()) ? path.substring(1) : path;
        Enumeration<Object> resources = Collections.emptyEnumeration();
        Iterator classLoadersIt = this.classloaders.toIterator();
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (classLoadersIt.hasNext()) {
            ClassLoader classLoader = (ClassLoader)((Function0)classLoadersIt.next()).apply();
            resources = classLoader.getResources(weaveFilePath);
            result.$plus$plus$eq((TraversableOnce)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(resources).asScala()).map((Function1 & Serializable & scala.Serializable)resource -> {
                DefaultWeaveResource defaultWeaveResource;
                try (BufferedSource source = Source$.MODULE$.fromInputStream(resource.openStream(), "UTF-8");){
                    defaultWeaveResource = WeaveResource$.MODULE$.apply(resource.toExternalForm(), source.mkString());
                }
                return defaultWeaveResource;
            }));
        }
        return result;
    }

    @Override
    public boolean canResolveResource(NameIdentifier name) {
        String path = NameIdentifierHelper$.MODULE$.toWeaveFilePath(name, ClassLoaderWeaveResourceResolver$.MODULE$.PATH_SEPARATOR());
        return this.resolveUrl(path).isDefined();
    }

    public ClassLoaderWeaveResourceResolver(Seq<Function0<ClassLoader>> classloaders) {
        this.classloaders = classloaders;
        WeaveResourceResolver.$init$(this);
    }
}

