package org.mule.weave.v2.utils

import org.mule.weave.v2.parser.location.WeaveLocation

case class DWSemanticToken(tokenType: String, tokenModifiers: Array[String], location: WeaveLocation) extends Ordered[DWSemanticToken] {
  override def compare(that: DWSemanticToken): Int = {
    val startOrder = this.location.startPosition.compare(that.location.startPosition)
    if (startOrder == 0) {
      this.location.endPosition.compare(that.location.endPosition)
    } else startOrder
  }
}

object SemanticTokenTypes {
  val NAMESPACE = "namespace"
  val CLASS = "class"
  val ENUM = "enum"
  val INTERFACE = "interface"
  val STRUCT = "struct"
  val TYPE_PARAMETER = "typeParameter"
  val TYPE = "type"
  val PARAMETER = "parameter"
  val VARIABLE = "variable"
  val PROPERTY = "property"
  val ENUM_MEMBER = "enumMember"
  val DECORATOR = "decorator"
  val EVENT = "event"
  val FUNCTION = "function"
  val METHOD = "method"
  val MACRO = "macro"
  val LABEL = "label"
  val COMMENT = "comment"
  val STRING = "string"
  val KEYWORD = "keyword"
  val NUMBER = "number"
  val REGEXP = "regexp"
  val OPERATOR = "operator"
}

object SemanticTokensModifiers {
  val DECLARATION = "declaration"
  val DEFINITION = "definition"
  val READ_ONLY = "readonly"
  val STATIC = "static"
  val DEPRECATED = "deprecated"
  val ABSTRACT = "abstract"
  val ASYNC = "async"
  val MODIFICATION = "modification"
  val DOCUMENTATION = "documentation"
  val DEFAULT_LIBRARY = "defaultLibrary"
}
