/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.editor.composer;

import java.io.Serializable;
import org.mule.weave.v2.codegen.CodeGenerator$;
import org.mule.weave.v2.editor.ValidationMessage;
import org.mule.weave.v2.editor.ValidationMessage$;
import org.mule.weave.v2.editor.composer.ComposerExpression;
import org.mule.weave.v2.editor.composer.ComposerExpressionNode;
import org.mule.weave.v2.editor.composer.ComposerExpressionToken;
import org.mule.weave.v2.editor.composer.ComposerExpressionTokenKind$;
import org.mule.weave.v2.editor.composer.ComposerParserResult;
import org.mule.weave.v2.editor.composer.ComposerValidationMessages;
import org.mule.weave.v2.parser.MappingParser$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.structure.BooleanNode;
import org.mule.weave.v2.parser.ast.structure.DateTimeNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.structure.LocalDateNode;
import org.mule.weave.v2.parser.ast.structure.LocalDateTimeNode;
import org.mule.weave.v2.parser.ast.structure.LocalTimeNode;
import org.mule.weave.v2.parser.ast.structure.NumberNode;
import org.mule.weave.v2.parser.ast.structure.RegexNode;
import org.mule.weave.v2.parser.ast.structure.StringInterpolationNode;
import org.mule.weave.v2.parser.ast.structure.StringNode;
import org.mule.weave.v2.parser.ast.structure.TimeNode;
import org.mule.weave.v2.parser.ast.structure.TimeZoneNode;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.TypeCheckingResult;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.utils.StringEscapeHelper$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Q4AAB\u0004\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!)Q\b\u0001C\u0001}!)a\n\u0001C\u0005\u001f\")q\r\u0001C\u0005Q\nA2i\\7q_N,'/\u0012=qe\u0016\u001c8/[8o!\u0006\u00148/\u001a:\u000b\u0005!I\u0011\u0001C2p[B|7/\u001a:\u000b\u0005)Y\u0011AB3eSR|'O\u0003\u0002\r\u001b\u0005\u0011aO\r\u0006\u0003\u001d=\tQa^3bm\u0016T!\u0001E\t\u0002\t5,H.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0006\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u00059\u0011!\u00029beN,G\u0003B\u0011%cM\u0002\"A\b\u0012\n\u0005\r:!\u0001F\"p[B|7/\u001a:QCJ\u001cXM\u001d*fgVdG\u000fC\u0003&\u0005\u0001\u0007a%\u0001\u0006fqB\u0014Xm]:j_:\u0004\"a\n\u0018\u000f\u0005!b\u0003CA\u0015\u0018\u001b\u0005Q#BA\u0016\u0014\u0003\u0019a$o\\8u}%\u0011QfF\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$AB*ue&twM\u0003\u0002./!)!G\u0001a\u0001M\u0005!a.Y7f\u0011\u0015!$\u00011\u00016\u00039\u0001\u0018M]:j]\u001e\u001cuN\u001c;fqR\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000bAD\u0017m]3\u000b\u0005iZ\u0011A\u00029beN,'/\u0003\u0002=o\tq\u0001+\u0019:tS:<7i\u001c8uKb$\u0018\u0001C4f]\u0016\u0014\u0018\r^3\u0015\u0007\u0019zT\nC\u0003A\u0007\u0001\u0007\u0011)\u0001\u0005fY\u0016lWM\u001c;t!\r\u0011uI\u0013\b\u0003\u0007\u0016s!!\u000b#\n\u0003aI!AR\f\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$\u0018!\tq2*\u0003\u0002M\u000f\t92i\\7q_N,'/\u0012=qe\u0016\u001c8/[8o)>\\WM\u001c\u0005\u0006i\r\u0001\r!N\u0001\u000eO\u0016tWM]1uK6{G-\u001a7\u0015\u0007A#F\fE\u0002C\u000fF\u0003\"A\b*\n\u0005M;!AF\"p[B|7/\u001a:FqB\u0014Xm]:j_:tu\u000eZ3\t\u000bU#\u0001\u0019\u0001,\u0002\u000f\u0005\u001cHOT8eKB\u0011qKW\u0007\u00021*\u0011\u0011,O\u0001\u0004CN$\u0018BA.Y\u0005\u001d\t5\u000f\u001e(pI\u0016DQ!\u0018\u0003A\u0002y\u000baA]3tk2$\bc\u0001\u001c`C&\u0011\u0001m\u000e\u0002\u0013)f\u0004Xm\u00115fG.Lgn\u001a*fgVdG\u000f\u0005\u0002cK6\t1M\u0003\u0002e1\u0006I1\u000f\u001e:vGR,(/Z\u0005\u0003M\u000e\u0014A\u0002R8dk6,g\u000e\u001e(pI\u0016\fA\u0004^8D_6\u0004xn]3s-\u0006d\u0017\u000eZ1uS>tW*Z:tC\u001e,7\u000f\u0006\u0002jYB\u0011aD[\u0005\u0003W\u001e\u0011!dQ8na>\u001cXM\u001d,bY&$\u0017\r^5p]6+7o]1hKNDQ!\\\u0003A\u00029\fQA^1mk\u0016\u00042AN8r\u0013\t\u0001xGA\u0006QQ\u0006\u001cXMU3tk2$\bc\u0001\u001csC&\u00111o\u000e\u0002\u000e!\u0006\u00148/\u001b8h%\u0016\u001cX\u000f\u001c;")
public class ComposerExpressionParser {
    public ComposerParserResult parse(String expression, String name, ParsingContext parsingContext) {
        ComposerParserResult composerParserResult;
        PhaseResult<ParsingResult<DocumentNode>> value = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.typeCheckPhase(), WeaveResource$.MODULE$.apply(name, expression), parsingContext);
        if (value.hasResult()) {
            ComposerValidationMessages composerValidationMessages = this.toComposerValidationMessages(value);
            TypeCheckingResult theResult = (TypeCheckingResult)value.getResult();
            composerParserResult = new ComposerParserResult(composerValidationMessages, (Option<ComposerExpression>)new Some((Object)new ComposerExpression(this.generateModel(((DocumentNode)theResult.astNode()).root(), theResult))));
        } else {
            ComposerValidationMessages composerValidationMessages = this.toComposerValidationMessages(value);
            composerParserResult = new ComposerParserResult(composerValidationMessages, (Option<ComposerExpression>)None$.MODULE$);
        }
        return composerParserResult;
    }

    public String generate(Seq<ComposerExpressionToken> elements, ParsingContext parsingContext) {
        Seq astNodes;
        return elements.isEmpty() ? "" : ((astNodes = (Seq)elements.map((Function1 & Serializable & scala.Serializable)element -> {
            AstNode astNode;
            String string = element.kind();
            String string2 = ComposerExpressionTokenKind$.MODULE$.TEXT();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                StringNode node = new StringNode(StringEscapeHelper$.MODULE$.escapeString(element.text(), '\"', false));
                Object object = elements.size() == 1 ? node.withQuotation('\"') : BoxedUnit.UNIT;
                astNode = node;
            } else {
                String expressionText = element.text();
                PhaseResult<ParsingResult<DocumentNode>> value = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.parsingPhase(), WeaveResource$.MODULE$.apply("expression", expressionText), parsingContext);
                astNode = value.getResult().astNode().root();
            }
            return astNode;
        }, Seq$.MODULE$.canBuildFrom())).size() > 1 ? CodeGenerator$.MODULE$.generate(new StringInterpolationNode((Seq<AstNode>)astNodes)) : CodeGenerator$.MODULE$.generate((AstNode)astNodes.head()));
    }

    private Seq<ComposerExpressionNode> generateModel(AstNode astNode, TypeCheckingResult<DocumentNode> result) {
        Seq seq;
        AstNode astNode2 = astNode;
        if (astNode2 instanceof StringNode) {
            StringNode stringNode = (StringNode)astNode2;
            String expression = StringEscapeHelper$.MODULE$.unescapeString(stringNode.literalValue(), BoxesRunTime.unboxToChar((Object)stringNode.quotedBy().getOrElse((Function0)(JFunction0.mcC.sp & Serializable & scala.Serializable)() -> '\"')));
            ComposerExpressionToken part = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.TEXT(), expression);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(part, astNode, result)}));
        } else if (astNode2 instanceof NumberNode) {
            NumberNode numberNode = (NumberNode)astNode2;
            ComposerExpressionToken part = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.NUMBER(), numberNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(part, astNode, result)}));
        } else if (astNode2 instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.BOOLEAN(), booleanNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof LocalDateNode) {
            LocalDateNode localDateNode = (LocalDateNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.DATE(), localDateNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof LocalTimeNode) {
            LocalTimeNode localTimeNode = (LocalTimeNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.TIME(), localTimeNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof TimeNode) {
            TimeNode timeNode = (TimeNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.TIME(), timeNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof LocalDateTimeNode) {
            LocalDateTimeNode localDateTimeNode = (LocalDateTimeNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.DATETIME(), localDateTimeNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof DateTimeNode) {
            DateTimeNode dateTimeNode = (DateTimeNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.DATETIME(), dateTimeNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof TimeZoneNode) {
            TimeZoneNode timeZoneNode = (TimeZoneNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.TIMEZONE(), timeZoneNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof RegexNode) {
            RegexNode regexNode = (RegexNode)astNode2;
            ComposerExpressionToken token = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.REGEX(), regexNode.literalValue());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{new ComposerExpressionNode(token, astNode, result)}));
        } else if (astNode2 instanceof StringInterpolationNode) {
            StringInterpolationNode stringInterpolationNode = (StringInterpolationNode)astNode2;
            seq = (Seq)stringInterpolationNode.elements().flatMap((Function1 & Serializable & scala.Serializable)nd -> this.generateModel((AstNode)nd, result), Seq$.MODULE$.canBuildFrom());
        } else {
            ComposerExpressionToken expressionPart = new ComposerExpressionToken(ComposerExpressionTokenKind$.MODULE$.EXPRESSION(), CodeGenerator$.MODULE$.generate(astNode2));
            ComposerExpressionNode composerNode = new ComposerExpressionNode(expressionPart, astNode, result);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ComposerExpressionNode[]{composerNode}));
        }
        return seq;
    }

    private ComposerValidationMessages toComposerValidationMessages(PhaseResult<ParsingResult<DocumentNode>> value) {
        MessageCollector messageCollector = value.messages();
        Seq<Tuple2<WeaveLocation, Message>> errorMessages = messageCollector.errorMessages();
        Seq<Tuple2<WeaveLocation, Message>> warningMessages = messageCollector.warningMessages();
        Seq warningValidationMessages = (Seq)warningMessages.map((Function1 & Serializable & scala.Serializable)pair -> new ValidationMessage((WeaveLocation)pair._1(), (Message)pair._2(), ValidationMessage$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
        Seq errorValidationMessages = (Seq)errorMessages.map((Function1 & Serializable & scala.Serializable)pair -> new ValidationMessage((WeaveLocation)pair._1(), (Message)pair._2(), ValidationMessage$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
        ComposerValidationMessages composerValidationMessages = new ComposerValidationMessages((Seq<ValidationMessage>)warningValidationMessages, (Seq<ValidationMessage>)errorValidationMessages);
        return composerValidationMessages;
    }
}

