/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.formatting;

import java.io.Serializable;
import org.mule.weave.v2.editor.WeaveTextDocument;
import org.mule.weave.v2.formatting.FormattingOptions;
import org.mule.weave.v2.grammar.AdditionOpId$;
import org.mule.weave.v2.grammar.AsOpId$;
import org.mule.weave.v2.grammar.AttributeValueSelectorOpId$;
import org.mule.weave.v2.grammar.BinaryOpIdentifier;
import org.mule.weave.v2.grammar.DivisionOpId$;
import org.mule.weave.v2.grammar.DynamicSelectorOpId$;
import org.mule.weave.v2.grammar.EqOpId$;
import org.mule.weave.v2.grammar.FilterSelectorOpId$;
import org.mule.weave.v2.grammar.GreaterThanOpId$;
import org.mule.weave.v2.grammar.IsOpId$;
import org.mule.weave.v2.grammar.LeftShiftOpId$;
import org.mule.weave.v2.grammar.LessOrEqualThanOpId$;
import org.mule.weave.v2.grammar.LessThanOpId$;
import org.mule.weave.v2.grammar.MultiAttributeValueSelectorOpId$;
import org.mule.weave.v2.grammar.MultiValueSelectorOpId$;
import org.mule.weave.v2.grammar.MultiplicationOpId$;
import org.mule.weave.v2.grammar.NotEqOpId$;
import org.mule.weave.v2.grammar.ObjectKeyValueSelectorOpId$;
import org.mule.weave.v2.grammar.RangeSelectorOpId$;
import org.mule.weave.v2.grammar.RightShiftOpId$;
import org.mule.weave.v2.grammar.SchemaValueSelectorOpId$;
import org.mule.weave.v2.grammar.SimilarOpId$;
import org.mule.weave.v2.grammar.SubtractionOpId$;
import org.mule.weave.v2.grammar.ValueSelectorOpId$;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.ContainerAstNode;
import org.mule.weave.v2.parser.ast.WeaveLocationCapable;
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode;
import org.mule.weave.v2.parser.ast.annotation.AnnotationNode;
import org.mule.weave.v2.parser.ast.conditional.IfNode;
import org.mule.weave.v2.parser.ast.conditional.UnlessNode;
import org.mule.weave.v2.parser.ast.functions.DoBlockNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode;
import org.mule.weave.v2.parser.ast.functions.FunctionNode;
import org.mule.weave.v2.parser.ast.functions.FunctionParameter;
import org.mule.weave.v2.parser.ast.header.HeaderNode;
import org.mule.weave.v2.parser.ast.header.directives.AnnotationDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.header.directives.TypeDirective;
import org.mule.weave.v2.parser.ast.header.directives.VarDirective;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.operators.BinaryOpNode;
import org.mule.weave.v2.parser.ast.patterns.PatternExpressionNode;
import org.mule.weave.v2.parser.ast.patterns.PatternExpressionsNode;
import org.mule.weave.v2.parser.ast.structure.ArrayNode;
import org.mule.weave.v2.parser.ast.structure.AttributesNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.structure.NameValuePairNode;
import org.mule.weave.v2.parser.ast.structure.ObjectNode;
import org.mule.weave.v2.parser.ast.structure.schema.SchemaNode;
import org.mule.weave.v2.parser.ast.types.KeyTypeNode;
import org.mule.weave.v2.parser.ast.types.KeyValueTypeNode;
import org.mule.weave.v2.parser.ast.types.NameValueTypeNode;
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode;
import org.mule.weave.v2.parser.ast.types.TypeParametersListNode;
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode;
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionNode;
import org.mule.weave.v2.parser.ast.updates.UpdateExpressionsNode;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.parser.location.SimpleParserPosition;
import org.mule.weave.v2.parser.location.WeaveLocation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u001a5\u0001}B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019I\u0006\u0001)A\u0005#\"9!\f\u0001b\u0001\n\u0003\u0001\u0006BB.\u0001A\u0003%\u0011\u000bC\u0004]\u0001\t\u0007I\u0011\u0001)\t\ru\u0003\u0001\u0015!\u0003R\u0011\u001dq\u0006A1A\u0005\u0002ACaa\u0018\u0001!\u0002\u0013\t\u0006b\u00021\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007C\u0002\u0001\u000b\u0011B)\t\u000f\t\u0004!\u0019!C\u0001!\"11\r\u0001Q\u0001\nECq\u0001\u001a\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004f\u0001\u0001\u0006I!\u0015\u0005\bM\u0002\u0011\r\u0011\"\u0001Q\u0011\u00199\u0007\u0001)A\u0005#\"9\u0001\u000e\u0001b\u0001\n\u0003\u0001\u0006BB5\u0001A\u0003%\u0011\u000bC\u0004k\u0001\t\u0007I\u0011\u0001)\t\r-\u0004\u0001\u0015!\u0003R\u0011\u001da\u0007A1A\u0005\u0002ACa!\u001c\u0001!\u0002\u0013\t\u0006b\u00028\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007_\u0002\u0001\u000b\u0011B)\t\u000fA\u0004!\u0019!C\u0001!\"1\u0011\u000f\u0001Q\u0001\nECqA\u001d\u0001C\u0002\u0013\u00051\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002;\t\u0011\u0005\r\u0001A1A\u0005\u0002MDq!!\u0002\u0001A\u0003%A\u000fC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\u0001\u0001\u0005\n\u0005\u0005\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002\b\u0001!I!a,\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003_\u0002A\u0011BAw\u0011\u001d\ty\u0007\u0001C\u0005\u0003sDqAa\u0005\u0001\t\u0013\u0011)\u0002C\u0004\u0003\u001e\u0001!IAa\b\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!Q\u0004\u0001\u0005\n\tE\u0002b\u0002B\u000f\u0001\u0011%!Q\b\u0002\u0012\r>\u0014X.\u0019;uS:<7+\u001a:wS\u000e,'BA\u001b7\u0003)1wN]7biRLgn\u001a\u0006\u0003oa\n!A\u001e\u001a\u000b\u0005eR\u0014!B<fCZ,'BA\u001e=\u0003\u0011iW\u000f\\3\u000b\u0003u\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g\u0003\u001dy\u0007\u000f^5p]N\u0004\"\u0001S%\u000e\u0003QJ!A\u0013\u001b\u0003#\u0019{'/\\1ui&twm\u00149uS>t7/\u0001\u0004=S:LGO\u0010\u000b\u0003\u001b:\u0003\"\u0001\u0013\u0001\t\u000b\u0019\u0013\u0001\u0019A$\u0002\u001fQK\u0006+R0T\u000bB\u000b%+\u0011+J\u001f:+\u0012!\u0015\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000bA\u0001\\1oO*\ta+\u0001\u0003kCZ\f\u0017B\u0001-T\u0005\u0019\u0019FO]5oO\u0006\u0001B+\u0017)F?N+\u0005+\u0011*B)&{e\nI\u0001\u0015\u0017\u0016KvLV!M+\u0016{6+\u0012)B%\u0006#\u0016j\u0014(\u0002+-+\u0015l\u0018,B\u0019V+ulU#Q\u0003J\u000bE+S(OA\u0005iQ)U0T\u000bB\u000b%+\u0011+J\u001f:\u000ba\"R)`'\u0016\u0003\u0016IU!U\u0013>s\u0005%A\tM\u00036\u0013E)Q0T\u000bB\u000b%+\u0011+J\u001f:\u000b!\u0003T!N\u0005\u0012\u000bulU#Q\u0003J\u000bE+S(OA\u0005\u00012iT'N\u0003~\u001bV\tU!S\u0003RKuJT\u0001\u0012\u0007>kU*Q0T\u000bB\u000b%+\u0011+J\u001f:\u0003\u0013AF\"M\u001fN+u\fU!S\u000b:{6+\u0012)B%\u0006#\u0016j\u0014(\u0002/\rcujU#`!\u0006\u0013VIT0T\u000bB\u000b%+\u0011+J\u001f:\u0003\u0013!F(Q\u000b:{\u0006+\u0011*F\u001d~\u001bV\tU!S\u0003RKuJT\u0001\u0017\u001fB+ej\u0018)B%\u0016sulU#Q\u0003J\u000bE+S(OA\u00051\u0012I\u0014(P)\u0006#\u0016j\u0014(`\t\u0016\u001bE*\u0011*B)&{e*A\fB\u001d:{E+\u0011+J\u001f:{F)R\"M\u0003J\u000bE+S(OA\u0005\u0001B+\u0017)F?\u0012+5\tT!S\u0003RKuJT\u0001\u0012)f\u0003Vi\u0018#F\u00072\u000b%+\u0011+J\u001f:\u0003\u0013a\u0004,B%~#Ui\u0011'B%\u0006#\u0016j\u0014(\u0002!Y\u000b%k\u0018#F\u00072\u000b%+\u0011+J\u001f:\u0003\u0013\u0001\u0006$V\u001d\u000e#\u0016j\u0014(`\t\u0016\u001bE*\u0011*B)&{e*A\u000bG+:\u001bE+S(O?\u0012+5\tT!S\u0003RKuJ\u0014\u0011\u0002\u001dM#\u0016I\u0015+`)f\u0003Vi\u0018*F\r\u0006y1\u000bV!S)~#\u0016\fU#`%\u00163\u0005%\u0001\u0007F\u001d\u0012{F+\u0017)F?J+e)A\u0007F\u001d\u0012{F+\u0017)F?J+e\tI\u0001\u001a%\u0016\u000bV+\u0013*F'~;\u0006*\u0013+F'B\u000b5)R0P!~KE)F\u0001u!\r)\bP_\u0007\u0002m*\u0011qOQ\u0001\u000bG>dG.Z2uS>t\u0017BA=w\u0005\r\u0019V-\u001d\t\u0003wzl\u0011\u0001 \u0006\u0003{Z\nqa\u001a:b[6\f'/\u0003\u0002\u0000y\n\u0011\")\u001b8bef|\u0005/\u00133f]RLg-[3s\u0003i\u0011V)U+J%\u0016\u001bvl\u0016%J)\u0016\u001b\u0006+Q\"F?>\u0003v,\u0013#!\u0003=\u0019V\tT#D)&{ejX(Q?&#\u0015\u0001E*F\u0019\u0016\u001bE+S(O?>\u0003v,\u0013#!\u0003\u00191wN]7biR1\u00111BA\t\u0003G\u00012!QA\u0007\u0013\r\tyA\u0011\u0002\u0005+:LG\u000fC\u0004\u0002\u0014\u0005\u0002\r!!\u0006\u0002\u0007\u0005\u001cH\u000f\u0005\u0003\u0002\u0018\u0005}QBAA\r\u0015\u0011\t\u0019\"a\u0007\u000b\u0007\u0005ua'\u0001\u0004qCJ\u001cXM]\u0005\u0005\u0003C\tIBA\u0004BgRtu\u000eZ3\t\u000f\u0005\u0015\u0012\u00051\u0001\u0002(\u0005AAm\\2v[\u0016tG\u000f\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCN\u0001\u0007K\u0012LGo\u001c:\n\t\u0005E\u00121\u0006\u0002\u0012/\u0016\fg/\u001a+fqR$unY;nK:$\u0018!H2bY\u000e,H.\u0019;f\u0005&t\u0017M]=Gk:\u001cG/[8o\u001f\u001a47/\u001a;\u0015\t\u0005]\u0012Q\b\t\u0004\u0003\u0006e\u0012bAA\u001e\u0005\n\u0019\u0011J\u001c;\t\u000f\u0005}\"\u00051\u0001\u0002\u0016\u0005Aa-\u001b:ti\u0006\u0013x\r\u0006\u0006\u0002\f\u0005\r\u0013QIA$\u0003\u0017Bq!a\u0005$\u0001\u0004\t)\u0002C\u0004\u0002&\r\u0002\r!a\n\t\u000f\u0005%3\u00051\u0001\u00028\u00051qN\u001a4tKRDq!!\u0014$\u0001\u0004\t9$\u0001\u0007qe\u00164\u0018n\\;t\u0019&tW-A\tjg&sg-\u001b=CS:\f'/_\"bY2$B!a\u0015\u0002ZA\u0019\u0011)!\u0016\n\u0007\u0005]#IA\u0004C_>dW-\u00198\t\u000f\u0005mC\u00051\u0001\u0002^\u0005\u0019am\u00198\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CRA!a\u0019\u0002\u001a\u0005Ia-\u001e8di&|gn]\u0005\u0005\u0003O\n\tG\u0001\tGk:\u001cG/[8o\u0007\u0006dGNT8eK\u0006a\u0011N\u001c3f]R|eMZ:fiR!\u0011qGA7\u0011\u001d\tI%\na\u0001\u0003o\t!b]3qCJ\fG/\u001a\"z)!\tY!a\u001d\u0002\u000e\u0006}\u0005bBA;M\u0001\u0007\u0011qO\u0001\u0006]>$Wm\u001d\t\u0007\u0003s\nI)!\u0006\u000f\t\u0005m\u0014Q\u0011\b\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011 \u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0015bAAD\u0005\u00069\u0001/Y2lC\u001e,\u0017bA=\u0002\f*\u0019\u0011q\u0011\"\t\u000f\u0005=e\u00051\u0001\u0002\u0012\u0006I1/\u001a9be\u0006$xN\u001d\t\u0005\u0003'\u000bYJ\u0004\u0003\u0002\u0016\u0006]\u0005cAA?\u0005&\u0019\u0011\u0011\u0014\"\u0002\rA\u0013X\rZ3g\u0013\rA\u0016Q\u0014\u0006\u0004\u00033\u0013\u0005bBA\u0013M\u0001\u0007\u0011qE\u0001\fS:$WM\u001c;DY>\u001cX\r\u0006\u0005\u0002\f\u0005\u0015\u0016qUAV\u0011\u001d\t)c\na\u0001\u0003OAq!!+(\u0001\u0004\t9$\u0001\u0004j]\u0012,g\u000e\u001e\u0005\b\u0003[;\u0003\u0019AA\u000b\u0003\u001d\t7\u000f\u001e(pI\u0016$\"\"a\u0003\u00022\u0006M\u0016QWA\\\u0011\u001d\t)\b\u000ba\u0001\u0003oBq!!\n)\u0001\u0004\t9\u0003C\u0004\u0002*\"\u0002\r!a\u000e\t\u000f\u0005e\u0006\u00061\u0001\u00028\u0005I1\u000f^1si2Kg.Z\u0001\u000fM>\u0014X.\u0019;Gk:\u001cG/[8o)1\tY!a0\u0002J\u0006-\u0017QZAi\u0011\u001d\t\t-\u000ba\u0001\u0003\u0007\f!A\u001a8\u0011\t\u0005}\u0013QY\u0005\u0005\u0003\u000f\f\tG\u0001\u0007Gk:\u001cG/[8o\u001d>$W\rC\u0004\u0002&%\u0002\r!a\n\t\u000f\u0005%\u0013\u00061\u0001\u00028!9\u0011qZ\u0015A\u0002\u0005]\u0012\u0001\u00027j]\u0016Dq!a5*\u0001\u0004\t\t*\u0001\ngk:\u001cG/[8o'\u0016\u0004\u0018M]1uS>t\u0017\u0001\u00064pe\u000e,wJ\\3Ta\u0006\u001cWMQ3uo\u0016,g\u000e\u0006\u0005\u0002\f\u0005e\u0017Q\\Aq\u0011\u001d\tYN\u000ba\u0001\u0003+\t\u0001\u0002\\3gi:{G-\u001a\u0005\b\u0003?T\u0003\u0019AA\u000b\u0003%\u0011\u0018n\u001a5u\u001d>$W\rC\u0004\u0002&)\u0002\r!a\n\u0002'\u0019|'oY3O_N\u0003\u0018mY3CKR<X-\u001a8\u0015\u0011\u0005-\u0011q]Au\u0003WDq!a7,\u0001\u0004\t)\u0002C\u0004\u0002`.\u0002\r!!\u0006\t\u000f\u0005\u00152\u00061\u0001\u0002(QQ\u00111BAx\u0003c\f\u00190a>\t\u000f\u0005mG\u00061\u0001\u0002\u0016!9\u0011q\u001c\u0017A\u0002\u0005U\u0001bBA{Y\u0001\u0007\u0011\u0011S\u0001\u0013Kb\u0004Xm\u0019;fIN+\u0007/\u0019:bi&|g\u000eC\u0004\u0002&1\u0002\r!a\n\u0015\u0015\u0005-\u00111 B\u0006\u0005\u001f\u0011\t\u0002C\u0004\u0002~6\u0002\r!a@\u0002\u00191,g\r\u001e'pG\u0006$\u0018n\u001c8\u0011\t\t\u0005!qA\u0007\u0003\u0005\u0007QAA!\u0002\u0002\u001c\u0005AAn\\2bi&|g.\u0003\u0003\u0003\n\t\r!\u0001\u0003)pg&$\u0018n\u001c8\t\u000f\t5Q\u00061\u0001\u0002\u0000\u0006i!/[4ii2{7-\u0019;j_:Dq!!>.\u0001\u0004\t\t\nC\u0004\u0002&5\u0002\r!a\n\u0002/\u0015\fX/\u00197t\u0013\u001etwN]3XQ&$Xm\u00159bG\u0016\u001cHCBA*\u0005/\u0011I\u0002C\u0004\u0002v:\u0002\r!!%\t\u000f\tma\u00061\u0001\u0002\u0012\u0006Q1/\u001a9be\u0006$\u0018n\u001c8\u0002\u0017\u0005\u0004\b\u000f\\=J]\u0012,g\u000e\u001e\u000b\t\u0003\u0017\u0011\tCa\t\u0003&!9\u00111C\u0018A\u0002\u0005U\u0001bBA\u0013_\u0001\u0007\u0011q\u0005\u0005\b\u0005Oy\u0003\u0019AA\u001c\u0003\u0019\u0019w\u000e\\;n]\u000692m\\;oi&s\u0017\u000e^5bY^C\u0017\u000e^3Ta\u0006\u001cWm\u001d\u000b\u0005\u0003o\u0011i\u0003C\u0004\u00030A\u0002\r!!%\u0002\tQ,\u0007\u0010\u001e\u000b\t\u0003\u0017\u0011\u0019Da\u000e\u0003:!9!QG\u0019A\u0002\u0005}\u0018!D:uCJ$\bk\\:ji&|g\u000eC\u0004\u0002&E\u0002\r!a\n\t\u000f\tm\u0012\u00071\u0001\u00028\u0005qQ\r\u001f9fGR,G-\u00138eK:$HCCA\u0006\u0005\u007f\u0011\tEa\u0011\u0003H!9\u0011Q\u0005\u001aA\u0002\u0005\u001d\u0002b\u0002B\u0018e\u0001\u0007\u0011\u0011\u0013\u0005\b\u0005\u000b\u0012\u0004\u0019AA\u001c\u00039\u0019H/\u0019:u\u0019&tW-\u00138eKbDqAa\u000f3\u0001\u0004\t9\u0004")
public class FormattingService {
    private final FormattingOptions options;
    private final String TYPE_SEPARATION;
    private final String KEY_VALUE_SEPARATION;
    private final String EQ_SEPARATION;
    private final String LAMBDA_SEPARATION;
    private final String COMMA_SEPARATION;
    private final String CLOSE_PAREN_SEPARATION;
    private final String OPEN_PAREN_SEPARATION;
    private final String ANNOTATION_DECLARATION;
    private final String TYPE_DECLARATION;
    private final String VAR_DECLARATION;
    private final String FUNCTION_DECLARATION;
    private final String START_TYPE_REF;
    private final String END_TYPE_REF;
    private final Seq<BinaryOpIdentifier> REQUIRES_WHITESPACE_OP_ID;
    private final Seq<BinaryOpIdentifier> SELECTION_OP_ID;

    public String TYPE_SEPARATION() {
        return this.TYPE_SEPARATION;
    }

    public String KEY_VALUE_SEPARATION() {
        return this.KEY_VALUE_SEPARATION;
    }

    public String EQ_SEPARATION() {
        return this.EQ_SEPARATION;
    }

    public String LAMBDA_SEPARATION() {
        return this.LAMBDA_SEPARATION;
    }

    public String COMMA_SEPARATION() {
        return this.COMMA_SEPARATION;
    }

    public String CLOSE_PAREN_SEPARATION() {
        return this.CLOSE_PAREN_SEPARATION;
    }

    public String OPEN_PAREN_SEPARATION() {
        return this.OPEN_PAREN_SEPARATION;
    }

    public String ANNOTATION_DECLARATION() {
        return this.ANNOTATION_DECLARATION;
    }

    public String TYPE_DECLARATION() {
        return this.TYPE_DECLARATION;
    }

    public String VAR_DECLARATION() {
        return this.VAR_DECLARATION;
    }

    public String FUNCTION_DECLARATION() {
        return this.FUNCTION_DECLARATION;
    }

    public String START_TYPE_REF() {
        return this.START_TYPE_REF;
    }

    public String END_TYPE_REF() {
        return this.END_TYPE_REF;
    }

    public Seq<BinaryOpIdentifier> REQUIRES_WHITESPACE_OP_ID() {
        return this.REQUIRES_WHITESPACE_OP_ID;
    }

    public Seq<BinaryOpIdentifier> SELECTION_OP_ID() {
        return this.SELECTION_OP_ID;
    }

    public void format(AstNode ast, WeaveTextDocument document) {
        this.format(ast, document, 0, -1);
    }

    public int calculateBinaryFunctionOffset(AstNode firstArg) {
        FunctionCallNode functionCallNode;
        AstNode astNode = firstArg;
        int n = astNode instanceof FunctionCallNode && this.isInfixBinaryCall(functionCallNode = (FunctionCallNode)astNode) ? this.calculateBinaryFunctionOffset((AstNode)functionCallNode.args().args().head()) : astNode.location().endPosition().column();
        return n;
    }

    private void format(AstNode ast, WeaveTextDocument document, int offset, int previousLine) {
        block50: {
            AstNode astNode;
            int startLine;
            while (true) {
                FunctionCallNode functionCallNode;
                int n;
                if (AstNodeHelper$.MODULE$.isInjectedNode(ast)) {
                    this.format(ast.children(), document, offset, previousLine);
                    return;
                }
                AstNode astNode2 = ast;
                if (astNode2 instanceof AnnotationCapableNode) {
                    AnnotationCapableNode annotationCapableNode = (AnnotationCapableNode)astNode2;
                    Seq<AnnotationNode> annotations = annotationCapableNode.codeAnnotations();
                    n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((SeqLike)annotations.filterNot((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)AstNodeHelper$.MODULE$.isInjectedNode(node)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$2(x$1)), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)BoxesRunTime.boxToInteger((int)previousLine), (Function2 & Serializable & scala.Serializable)(line, child) -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$3(this, document, offset, BoxesRunTime.unboxToInt((Object)line), child))));
                } else {
                    n = previousLine;
                }
                int newPreviousLine = n;
                startLine = ast.location().startPosition().line();
                if (startLine > newPreviousLine) {
                    this.applyIndent(ast, document, offset);
                }
                boolean bl = false;
                BinaryOpNode binaryOpNode = null;
                astNode = ast;
                boolean bl2 = astNode instanceof DocumentNode ? true : astNode instanceof ModuleNode;
                if (bl2) {
                    this.format(ast.children(), document, offset, 0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof FunctionNode) {
                    FunctionNode functionNode = (FunctionNode)astNode;
                    this.formatFunction(functionNode, document, offset, startLine, this.LAMBDA_SEPARATION());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof FunctionDirectiveNode) {
                    AstNode astNode3;
                    FunctionDirectiveNode functionDirectiveNode = (FunctionDirectiveNode)astNode;
                    if (functionDirectiveNode.codeAnnotations().isEmpty()) {
                        this.separateBy(functionDirectiveNode.location().startPosition(), functionDirectiveNode.variable().location().startPosition(), this.FUNCTION_DECLARATION(), document);
                    }
                    if (!((astNode3 = functionDirectiveNode.literal()) instanceof FunctionNode)) {
                        previousLine = functionDirectiveNode.variable().location().endPosition().line();
                        ast = astNode3;
                        continue;
                    }
                    FunctionNode functionNode = (FunctionNode)astNode3;
                    this.formatFunction(functionNode, document, offset, functionDirectiveNode.variable().location().endPosition().line(), this.EQ_SEPARATION());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof FunctionParameter) {
                    BoxedUnit boxedUnit;
                    FunctionParameter functionParameter = (FunctionParameter)astNode;
                    if (functionParameter.wtype().isDefined()) {
                        this.separateBy(functionParameter.variable(), (AstNode)functionParameter.wtype().get(), this.TYPE_SEPARATION(), document);
                    }
                    if (functionParameter.defaultValue().isDefined()) {
                        Position leftPosition = (Position)functionParameter.wtype().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.location().endPosition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> functionParameter.variable().location().endPosition());
                        this.separateBy(leftPosition, ((WeaveLocationCapable)functionParameter.defaultValue().get()).location().startPosition(), this.EQ_SEPARATION(), document);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                    break block50;
                }
                if (astNode instanceof VarDirective) {
                    VarDirective varDirective = (VarDirective)astNode;
                    if (varDirective.codeAnnotations().isEmpty()) {
                        this.separateBy(varDirective.location().startPosition(), varDirective.variable().location().startPosition(), this.VAR_DECLARATION(), document);
                    }
                    if (varDirective.wtype().isDefined()) {
                        this.separateBy(varDirective.variable(), (AstNode)varDirective.wtype().get(), this.TYPE_SEPARATION(), document);
                    }
                    this.separateBy(varDirective.variable(), varDirective.value(), this.EQ_SEPARATION(), document);
                    previousLine = varDirective.variable().location().startPosition().line();
                    offset = this.indentOffset(offset);
                    ast = varDirective.value();
                    continue;
                }
                if (astNode instanceof TypeDirective) {
                    Option<TypeParametersListNode> typeParametersListNode;
                    TypeDirective typeDirective = (TypeDirective)astNode;
                    if (typeDirective.codeAnnotations().isEmpty()) {
                        this.separateBy(typeDirective.location().startPosition(), typeDirective.variable().location().startPosition(), this.TYPE_DECLARATION(), document);
                    }
                    if ((typeParametersListNode = typeDirective.typeParametersListNode()).isDefined() && ((TypeParametersListNode)typeParametersListNode.get()).typeParameters().nonEmpty()) {
                        TypeParametersListNode typeParamList = (TypeParametersListNode)typeParametersListNode.get();
                        this.separateBy(typeDirective.variable().location().endPosition(), ((WeaveLocationCapable)typeParamList.typeParameters().head()).location().startPosition(), this.START_TYPE_REF(), document);
                        this.separateBy(typeParamList.typeParameters(), this.COMMA_SEPARATION(), document);
                        this.separateBy(((WeaveLocationCapable)typeParamList.typeParameters().last()).location().endPosition(), typeDirective.typeExpression().location().startPosition(), new StringBuilder(1).append(this.END_TYPE_REF()).append(" ").append(this.EQ_SEPARATION()).toString(), document);
                    } else {
                        this.separateBy(typeDirective.variable(), typeDirective.typeExpression(), this.EQ_SEPARATION(), document);
                    }
                    previousLine = typeDirective.variable().location().endPosition().line();
                    ast = typeDirective.typeExpression();
                    continue;
                }
                if (astNode instanceof SchemaNode) {
                    SchemaNode schemaNode = (SchemaNode)astNode;
                    this.separateBy(schemaNode.properties(), this.COMMA_SEPARATION(), document);
                    this.format(schemaNode.children(), document, offset, startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof AnnotationDirectiveNode) {
                    AnnotationDirectiveNode annotationDirectiveNode = (AnnotationDirectiveNode)astNode;
                    this.separateBy(annotationDirectiveNode.location().startPosition(), annotationDirectiveNode.nameIdentifier().location().startPosition(), this.ANNOTATION_DECLARATION(), document);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof ObjectTypeNode) {
                    ObjectTypeNode objectTypeNode = (ObjectTypeNode)astNode;
                    this.format(objectTypeNode.children(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, objectTypeNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof NameValueTypeNode) {
                    NameValueTypeNode nameValueTypeNode = (NameValueTypeNode)astNode;
                    this.separateBy(nameValueTypeNode.name(), nameValueTypeNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(nameValueTypeNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof KeyValueTypeNode) {
                    KeyValueTypeNode keyValueTypeNode = (KeyValueTypeNode)astNode;
                    this.separateBy(keyValueTypeNode.key(), keyValueTypeNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(keyValueTypeNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof KeyTypeNode) {
                    KeyTypeNode keyTypeNode = (KeyTypeNode)astNode;
                    this.separateBy(keyTypeNode.attrs(), this.COMMA_SEPARATION(), document);
                    this.format(keyTypeNode.children(), document, offset, startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof TypeReferenceNode) {
                    TypeReferenceNode typeReferenceNode = (TypeReferenceNode)astNode;
                    if (typeReferenceNode.typeArguments().isDefined() && ((TraversableOnce)typeReferenceNode.typeArguments().get()).nonEmpty()) {
                        this.separateBy((Seq<AstNode>)((Seq)typeReferenceNode.typeArguments().get()), this.COMMA_SEPARATION(), document);
                        this.separateBy(typeReferenceNode.variable().location().endPosition(), ((WeaveLocationCapable)((IterableLike)typeReferenceNode.typeArguments().get()).head()).location().startPosition(), this.START_TYPE_REF(), document);
                        this.separateBy(((WeaveLocationCapable)((TraversableLike)typeReferenceNode.typeArguments().get()).last()).location().endPosition(), typeReferenceNode.location().endPosition(), this.END_TYPE_REF(), document);
                    }
                    this.format(typeReferenceNode.children(), document, offset, startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof FunctionCallNode && this.isInfixBinaryCall(functionCallNode = (FunctionCallNode)astNode)) {
                    AstNode firstArg = (AstNode)functionCallNode.args().args().head();
                    AstNode secondArg = (AstNode)functionCallNode.args().args().last();
                    this.format(firstArg, document, offset, startLine);
                    this.forceOneSpaceBetween(firstArg, functionCallNode.function(), document);
                    int functionOffset = this.indentOffset(offset);
                    this.format(functionCallNode.function(), document, functionOffset, firstArg.location().endPosition().line());
                    this.forceOneSpaceBetween(functionCallNode.function(), secondArg, document);
                    int secondParamOffset = this.indentOffset(functionOffset);
                    previousLine = functionCallNode.function().location().endPosition().line();
                    offset = secondParamOffset;
                    ast = secondArg;
                    continue;
                }
                if (astNode instanceof FunctionCallParametersNode) {
                    FunctionCallParametersNode functionCallParametersNode = (FunctionCallParametersNode)astNode;
                    this.format(functionCallParametersNode.args(), document, this.indentOffset(offset), previousLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)astNode;
                    this.separateBy(objectNode.elements(), this.COMMA_SEPARATION(), document);
                    this.format(objectNode.elements(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, objectNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof KeyValuePairNode) {
                    KeyValuePairNode keyValuePairNode = (KeyValuePairNode)astNode;
                    this.separateBy(keyValuePairNode.key(), keyValuePairNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(keyValuePairNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof AttributesNode) {
                    AttributesNode attributesNode = (AttributesNode)astNode;
                    Seq<AstNode> paramList = attributesNode.children();
                    this.separateBy(paramList, this.COMMA_SEPARATION(), document);
                    this.format(attributesNode.children(), document, offset, startLine);
                    this.indentClose(document, offset, attributesNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof NameValuePairNode) {
                    NameValuePairNode nameValuePairNode = (NameValuePairNode)astNode;
                    this.separateBy(nameValuePairNode.key(), nameValuePairNode.value(), this.KEY_VALUE_SEPARATION(), document);
                    this.format(nameValuePairNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof DoBlockNode) {
                    DoBlockNode doBlockNode = (DoBlockNode)astNode;
                    HeaderNode headerNode = doBlockNode.header();
                    AstNode bodyNode = doBlockNode.body();
                    this.format(headerNode, document, this.indentOffset(offset), startLine);
                    Position bodyStartPosition = bodyNode.location().startPosition();
                    Position headerEndPosition = headerNode.location().endPosition();
                    if (!AstNodeHelper$.MODULE$.isInjectedNode(headerNode) && headerEndPosition.line() != bodyStartPosition.line()) {
                        this.applyIndent(headerEndPosition, document, this.indentOffset(offset));
                    }
                    this.format(bodyNode, document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, doBlockNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof BinaryOpNode) {
                    bl = true;
                    binaryOpNode = (BinaryOpNode)astNode;
                    if (this.REQUIRES_WHITESPACE_OP_ID().contains((Object)binaryOpNode.binaryOpId())) {
                        this.separateBy(binaryOpNode.lhs(), binaryOpNode.rhs(), new StringBuilder(2).append(" ").append(binaryOpNode.binaryOpId().name()).append(" ").toString(), document);
                        this.format(binaryOpNode.children(), document, offset, startLine);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block50;
                    }
                }
                if (bl && this.SELECTION_OP_ID().contains((Object)binaryOpNode.binaryOpId())) {
                    AstNode lhs = binaryOpNode.lhs();
                    AstNode rhs = binaryOpNode.rhs();
                    this.forceNoSpaceBetween(lhs, rhs, document);
                    this.format(lhs, document, offset, startLine);
                    previousLine = startLine;
                    offset = this.indentOffset(offset);
                    ast = rhs;
                    continue;
                }
                if (astNode instanceof IfNode) {
                    IfNode ifNode = (IfNode)astNode;
                    this.format(ifNode.condition(), document, this.indentOffset(offset), startLine);
                    this.format(ifNode.ifExpr(), document, this.indentOffset(offset), ifNode.condition().location().endPosition().line());
                    if (!(ifNode.elseExpr() instanceof IfNode)) {
                        int elseLineNumber = ifNode.ifExpr().location().endPosition().line();
                        String textBetween = document.text(ifNode.ifExpr().location().endPosition().index(), ifNode.elseExpr().location().startPosition().index());
                        Iterator lines = new StringOps(Predef$.MODULE$.augmentString(textBetween)).linesIterator();
                        int location = ifNode.ifExpr().location().endPosition().index();
                        boolean elseFound = false;
                        while (lines.hasNext() && !elseFound) {
                            String line2 = (String)lines.next();
                            if (line2.trim().startsWith("else")) {
                                elseFound = true;
                                if (elseLineNumber == ifNode.elseExpr().location().startPosition().line()) continue;
                                this.applyIndent(document, line2, location, offset);
                                continue;
                            }
                            ++elseLineNumber;
                            location = location + line2.length() + 1;
                        }
                        if (elseLineNumber != ifNode.elseExpr().location().startPosition().line()) {
                            previousLine = ifNode.ifExpr().location().endPosition().line();
                            offset = this.indentOffset(offset);
                            ast = ifNode.elseExpr();
                            continue;
                        }
                        previousLine = ifNode.ifExpr().location().endPosition().line();
                        ast = ifNode.elseExpr();
                        continue;
                    }
                    previousLine = ifNode.ifExpr().location().endPosition().line();
                    ast = ifNode.elseExpr();
                    continue;
                }
                if (astNode instanceof UnlessNode) {
                    UnlessNode unlessNode = (UnlessNode)astNode;
                    this.format(unlessNode.children(), document, this.indentOffset(offset), startLine);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)astNode;
                    this.format(arrayNode.elements(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, arrayNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof PatternExpressionsNode) {
                    PatternExpressionsNode patternExpressionsNode = (PatternExpressionsNode)astNode;
                    this.format(patternExpressionsNode.children(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, patternExpressionsNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (astNode instanceof PatternExpressionNode) {
                    PatternExpressionNode patternExpressionNode = (PatternExpressionNode)astNode;
                    previousLine = startLine;
                    offset = this.indentOffset(offset);
                    ast = patternExpressionNode.onMatch();
                    continue;
                }
                if (astNode instanceof UpdateExpressionsNode) {
                    UpdateExpressionsNode updateExpressionsNode = (UpdateExpressionsNode)astNode;
                    this.format(updateExpressionsNode.children(), document, this.indentOffset(offset), startLine);
                    this.indentClose(document, offset, updateExpressionsNode);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block50;
                }
                if (!(astNode instanceof UpdateExpressionNode)) break;
                UpdateExpressionNode updateExpressionNode = (UpdateExpressionNode)astNode;
                previousLine = startLine;
                offset = this.indentOffset(offset);
                ast = updateExpressionNode.updateExpression();
            }
            this.format(astNode.children(), document, offset, startLine);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private boolean isInfixBinaryCall(FunctionCallNode fcn) {
        return AstNodeHelper$.MODULE$.isInfixFunctionCall(fcn) && fcn.args().args().length() == 2;
    }

    private int indentOffset(int offset) {
        return offset + (this.options.insertSpaces() ? this.options.tabSize() : 1);
    }

    public void separateBy(Seq<AstNode> nodes, String separator, WeaveTextDocument document) {
        int i = 1;
        while (i < nodes.size()) {
            this.separateBy((AstNode)nodes.apply(i - 1), (AstNode)nodes.apply(i), separator, document);
            i = this.indentOffset(i);
        }
    }

    private void indentClose(WeaveTextDocument document, int indent, AstNode astNode) {
        block0: {
            Position startPosition = (Position)astNode.children().lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.location().endPosition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> astNode.location().startPosition());
            Position endPosition = astNode.location().endPosition();
            if (startPosition.line() == endPosition.line()) break block0;
            SimpleParserPosition leftPosition = new SimpleParserPosition(endPosition.index() - 1, endPosition.line(), endPosition.column() - 1, endPosition.source());
            this.applyIndent(leftPosition, document, indent);
        }
    }

    private void format(Seq<AstNode> nodes, WeaveTextDocument document, int indent, int startLine) {
        ((TraversableOnce)((SeqLike)nodes.filterNot((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)AstNodeHelper$.MODULE$.isInjectedNode(node)))).sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$7(x$4)), (Ordering)Ordering.Int$.MODULE$)).foldLeft((Object)BoxesRunTime.boxToInteger((int)startLine), (Function2 & Serializable & scala.Serializable)(line, child) -> BoxesRunTime.boxToInteger((int)FormattingService.$anonfun$format$8(this, document, indent, BoxesRunTime.unboxToInt((Object)line), child)));
    }

    private void formatFunction(FunctionNode fn, WeaveTextDocument document, int offset, int line, String functionSeparation) {
        Option lastParameter;
        Seq<FunctionParameter> paramList = fn.params().paramList();
        this.separateBy(paramList, this.COMMA_SEPARATION(), document);
        int paramsOffset = fn.params().location().startPosition().column();
        this.format(paramList, document, paramsOffset, fn.params().location().startPosition().line());
        if (fn.returnType().isDefined()) {
            this.separateBy(fn.params(), (AstNode)fn.returnType().get(), this.TYPE_SEPARATION(), document);
            this.separateBy((AstNode)fn.returnType().get(), fn.body(), functionSeparation, document);
        } else {
            this.separateBy(fn.params(), fn.body(), functionSeparation, document);
        }
        Option headParam = fn.params().paramList().headOption();
        if (headParam.isDefined()) {
            this.separateBy(fn.params().location().startPosition(), ((ContainerAstNode)headParam.get()).location().startPosition(), this.OPEN_PAREN_SEPARATION(), document);
        }
        if ((lastParameter = fn.params().paramList().lastOption()).isDefined()) {
            this.separateBy(((ContainerAstNode)lastParameter.get()).location().endPosition(), fn.params().location().endPosition(), this.CLOSE_PAREN_SEPARATION(), document);
        }
        this.format(fn.body(), document, this.indentOffset(offset), line);
    }

    private void forceOneSpaceBetween(AstNode leftNode, AstNode rightNode, WeaveTextDocument document) {
        block0: {
            int i;
            WeaveLocation leftLocation;
            block1: {
                if (AstNodeHelper$.MODULE$.isInjectedNode(leftNode) || AstNodeHelper$.MODULE$.isInjectedNode(rightNode)) break block0;
                leftLocation = leftNode.location();
                WeaveLocation rightLocation = rightNode.location();
                if (leftLocation.endPosition().line() != rightLocation.startPosition().line()) break block0;
                String nextChar = document.text(leftLocation.endPosition().index(), rightLocation.startPosition().index());
                i = this.countInitialWhiteSpaces(nextChar);
                if (i <= 1) break block1;
                document.delete(leftLocation.endPosition().index(), leftLocation.endPosition().index() + (i - 1));
                break block0;
            }
            if (i != 0) break block0;
            document.insert(" ", leftLocation.endPosition().index());
        }
    }

    private void forceNoSpaceBetween(AstNode leftNode, AstNode rightNode, WeaveTextDocument document) {
        block1: {
            String nextChar;
            int i;
            if (AstNodeHelper$.MODULE$.isInjectedNode(leftNode) || AstNodeHelper$.MODULE$.isInjectedNode(rightNode)) break block1;
            WeaveLocation leftLocation = leftNode.location();
            WeaveLocation rightLocation = rightNode.location();
            if (leftLocation.endPosition().line() == rightLocation.startPosition().line() && (i = this.countInitialWhiteSpaces(nextChar = document.text(leftLocation.endPosition().index(), rightLocation.startPosition().index()))) > 0) {
                document.delete(leftLocation.endPosition().index(), leftLocation.endPosition().index() + i);
            }
        }
    }

    private void separateBy(AstNode leftNode, AstNode rightNode, String expectedSeparation, WeaveTextDocument document) {
        block0: {
            if (AstNodeHelper$.MODULE$.isInjectedNode(leftNode) || AstNodeHelper$.MODULE$.isInjectedNode(rightNode)) break block0;
            WeaveLocation leftLocation = leftNode.location();
            WeaveLocation rightLocation = rightNode.location();
            this.separateBy(leftLocation.endPosition(), rightLocation.startPosition(), expectedSeparation, document);
        }
    }

    private void separateBy(Position leftLocation, Position rightLocation, String expectedSeparation, WeaveTextDocument document) {
        int endIndex;
        int startIndex = leftLocation.index();
        String separation = document.text(startIndex, endIndex = rightLocation.index());
        if (this.equalsIgnoreWhiteSpaces(expectedSeparation, separation)) {
            if (!separation.equals(expectedSeparation)) {
                if (leftLocation.line() != rightLocation.line()) {
                    String rightTrim = separation.replaceAll("\\s+$", "");
                    document.replace(startIndex, startIndex + rightTrim.length(), expectedSeparation);
                } else {
                    document.replace(startIndex, endIndex, expectedSeparation);
                }
            }
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(4).append(separation.trim()).append(" != ").append(expectedSeparation).toString());
        }
    }

    private boolean equalsIgnoreWhiteSpaces(String expectedSeparation, String separation) {
        return separation.replaceAll("\\s+", "").equals(expectedSeparation.replaceAll("\\s+", ""));
    }

    private void applyIndent(AstNode ast, WeaveTextDocument document, int column) {
        Position startPosition = ast.location().startPosition();
        this.applyIndent(startPosition, document, column);
    }

    /*
     * WARNING - void declaration
     */
    public int countInitialWhiteSpaces(String text) {
        void var2_2;
        for (int i = 0; i < text.length() && RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(text.charAt(i))); ++i) {
        }
        return (int)var2_2;
    }

    private void applyIndent(Position startPosition, WeaveTextDocument document, int expectedIndent) {
        int actualColumn = startPosition.column() - 1;
        int startLineIndex = startPosition.index() - actualColumn;
        String text = document.text(startLineIndex, startPosition.index());
        this.applyIndent(document, text, startLineIndex, expectedIndent);
    }

    private void applyIndent(WeaveTextDocument document, String text, int startLineIndex, int expectedIndent) {
        block2: {
            int currentIndent = this.countInitialWhiteSpaces(text);
            if (currentIndent == expectedIndent) break block2;
            int diffSpaces = expectedIndent - currentIndent;
            if (diffSpaces < 0) {
                document.delete(startLineIndex, startLineIndex - diffSpaces);
            } else {
                String spaces = this.options.insertSpaces() ? " " : "\t";
                document.insert(new StringOps(Predef$.MODULE$.augmentString(spaces)).$times(diffSpaces), startLineIndex);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$format$2(AnnotationNode x$1) {
        return x$1.location().startPosition().index();
    }

    public static final /* synthetic */ int $anonfun$format$3(FormattingService $this, WeaveTextDocument document$1, int offset$1, int line, AnnotationNode child) {
        $this.format(child, document$1, offset$1, line);
        return child.location().endPosition().line();
    }

    public static final /* synthetic */ int $anonfun$format$7(AstNode x$4) {
        return x$4.location().startPosition().index();
    }

    public static final /* synthetic */ int $anonfun$format$8(FormattingService $this, WeaveTextDocument document$2, int indent$1, int line, AstNode child) {
        $this.format(child, document$2, indent$1, line);
        return child.location().endPosition().line();
    }

    public FormattingService(FormattingOptions options) {
        this.options = options;
        this.TYPE_SEPARATION = ": ";
        this.KEY_VALUE_SEPARATION = ": ";
        this.EQ_SEPARATION = " = ";
        this.LAMBDA_SEPARATION = " -> ";
        this.COMMA_SEPARATION = ", ";
        this.CLOSE_PAREN_SEPARATION = ")";
        this.OPEN_PAREN_SEPARATION = "(";
        this.ANNOTATION_DECLARATION = "annotation ";
        this.TYPE_DECLARATION = "type ";
        this.VAR_DECLARATION = "var ";
        this.FUNCTION_DECLARATION = "fun ";
        this.START_TYPE_REF = "<";
        this.END_TYPE_REF = ">";
        this.REQUIRES_WHITESPACE_OP_ID = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryOpIdentifier[]{AdditionOpId$.MODULE$, IsOpId$.MODULE$, SubtractionOpId$.MODULE$, DivisionOpId$.MODULE$, MultiplicationOpId$.MODULE$, RightShiftOpId$.MODULE$, LeftShiftOpId$.MODULE$, EqOpId$.MODULE$, NotEqOpId$.MODULE$, GreaterThanOpId$.MODULE$, SimilarOpId$.MODULE$, LessThanOpId$.MODULE$, LessOrEqualThanOpId$.MODULE$, AsOpId$.MODULE$}));
        this.SELECTION_OP_ID = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BinaryOpIdentifier[]{AttributeValueSelectorOpId$.MODULE$, MultiValueSelectorOpId$.MODULE$, MultiAttributeValueSelectorOpId$.MODULE$, DynamicSelectorOpId$.MODULE$, SchemaValueSelectorOpId$.MODULE$, ValueSelectorOpId$.MODULE$, ObjectKeyValueSelectorOpId$.MODULE$, FilterSelectorOpId$.MODULE$, RangeSelectorOpId$.MODULE$}));
    }
}

