/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module;

import org.mule.weave.v2.module.InvalidMimeTypeExpression;
import org.mule.weave.v2.module.MimeType;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class MimeType$
implements Serializable {
    public static MimeType$ MODULE$;
    private final MimeType MULTIPART_FORM_DATA;
    private final String WILDCARD_TYPE;
    private final String CHARSET;
    private final Seq<Object> NEEDS_QUOTES;
    private final Seq<Object> NEEDS_ESCAPE;
    private final String ANY_MIME_TYPE;
    private final String JAVA_MIME_TYPE;
    private final String INTERNAL_MIME_TYPE;
    private final MimeType APPLICATION_JAVA;
    private final MimeType OCTET_STREAM;
    private final MimeType APPLICATION_JSON;
    private final MimeType APPLICATION_XML;
    private final MimeType ANY;

    static {
        new MimeType$();
    }

    public Map<String, String> $lessinit$greater$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public MimeType MULTIPART_FORM_DATA() {
        return this.MULTIPART_FORM_DATA;
    }

    public String WILDCARD_TYPE() {
        return this.WILDCARD_TYPE;
    }

    public String CHARSET() {
        return this.CHARSET;
    }

    public Seq<Object> NEEDS_QUOTES() {
        return this.NEEDS_QUOTES;
    }

    public Seq<Object> NEEDS_ESCAPE() {
        return this.NEEDS_ESCAPE;
    }

    public String ANY_MIME_TYPE() {
        return this.ANY_MIME_TYPE;
    }

    public String JAVA_MIME_TYPE() {
        return this.JAVA_MIME_TYPE;
    }

    public String INTERNAL_MIME_TYPE() {
        return this.INTERNAL_MIME_TYPE;
    }

    public MimeType APPLICATION_JAVA() {
        return this.APPLICATION_JAVA;
    }

    public MimeType OCTET_STREAM() {
        return this.OCTET_STREAM;
    }

    public MimeType APPLICATION_JSON() {
        return this.APPLICATION_JSON;
    }

    public MimeType APPLICATION_XML() {
        return this.APPLICATION_XML;
    }

    public MimeType ANY() {
        return this.ANY;
    }

    public MimeType fromSimpleString(String mediaType) {
        MimeType mimeType;
        if (mediaType.equals(this.ANY_MIME_TYPE())) {
            mimeType = this.ANY();
        } else if (mediaType.equals(this.JAVA_MIME_TYPE())) {
            mimeType = this.APPLICATION_JAVA();
        } else if (mediaType.equals("application/json")) {
            mimeType = this.APPLICATION_JSON();
        } else if (mediaType.equals("application/xml")) {
            mimeType = this.APPLICATION_XML();
        } else {
            int slashIndex = mediaType.indexOf("/");
            int semIndex = mediaType.indexOf(";");
            if (slashIndex < 0 && semIndex < 0) {
                throw new InvalidMimeTypeExpression(mediaType, UnknownLocation$.MODULE$);
            }
            if (slashIndex < 0 && semIndex >= 0) {
                throw new InvalidMimeTypeExpression(mediaType, UnknownLocation$.MODULE$);
            }
            if (slashIndex >= 0 && semIndex < 0) {
                String primaryType = mediaType.substring(0, slashIndex).trim().toLowerCase();
                String subType = mediaType.substring(slashIndex + 1).trim().toLowerCase();
                mimeType = new MimeType(primaryType, subType, this.$lessinit$greater$default$3());
            } else {
                if (slashIndex >= semIndex) {
                    throw new InvalidMimeTypeExpression(mediaType, UnknownLocation$.MODULE$);
                }
                String primaryType = mediaType.substring(0, slashIndex).trim().toLowerCase();
                String subType = mediaType.substring(slashIndex + 1, semIndex).trim().toLowerCase();
                String propertiesString = mediaType.substring(semIndex);
                Map<String, String> properties = this.parseProperties(propertiesString);
                mimeType = new MimeType(primaryType, subType, properties);
            }
        }
        return mimeType;
    }

    public Map<String, String> parseProperties(String propertiesString) {
        boolean insideQuote = false;
        StringBuilder content = new StringBuilder();
        String name = null;
        ArrayBuffer properties = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; i < propertiesString.length(); ++i) {
            Object object;
            char c = propertiesString.charAt(i);
            char c2 = c;
            if ('\"' == c2) {
                insideQuote = !insideQuote;
                object = BoxedUnit.UNIT;
                continue;
            }
            if (insideQuote) {
                object = content.append(c);
                continue;
            }
            if ('=' == c2 && name == null) {
                name = content.toString().trim();
                content.clear();
                object = BoxedUnit.UNIT;
                continue;
            }
            if (';' == c2) {
                BoxedUnit boxedUnit;
                if (name != null && content.nonEmpty()) {
                    properties.$plus$eq((Object)new Tuple2((Object)name, (Object)content.toString()));
                    name = null;
                    content.clear();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = boxedUnit;
                continue;
            }
            object = '\\' == c2 ? BoxedUnit.UNIT : content.append(c);
        }
        Object object = name != null && content.nonEmpty() ? properties.$plus$eq((Object)new Tuple2(name, (Object)content.toString())) : BoxedUnit.UNIT;
        return properties.toMap(Predef$.MODULE$.$conforms());
    }

    public MimeType apply(String mainType, String subtype, Map<String, String> parameters) {
        return new MimeType(mainType, subtype, parameters);
    }

    public Map<String, String> apply$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<Tuple3<String, String, Map<String, String>>> unapply(MimeType x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.mainType(), (Object)x$0.subtype(), x$0.parameters()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MimeType$() {
        MODULE$ = this;
        this.MULTIPART_FORM_DATA = new MimeType("multipart", "form-data", this.$lessinit$greater$default$3());
        this.WILDCARD_TYPE = "*";
        this.CHARSET = "charset";
        this.NEEDS_QUOTES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '<', '>', '/', '[', ']', '?', '.', '=', '\n'}));
        this.NEEDS_ESCAPE = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'\"', '\\'}));
        this.ANY_MIME_TYPE = "*/*";
        this.JAVA_MIME_TYPE = "application/java";
        this.INTERNAL_MIME_TYPE = "internal/internal";
        this.APPLICATION_JAVA = new MimeType("application", "java", this.$lessinit$greater$default$3());
        this.OCTET_STREAM = new MimeType("application", "octet-stream", this.$lessinit$greater$default$3());
        this.APPLICATION_JSON = new MimeType("application", "json", this.$lessinit$greater$default$3());
        this.APPLICATION_XML = new MimeType("application", "xml", this.$lessinit$greater$default$3());
        this.ANY = new MimeType("*", "*", this.$lessinit$greater$default$3());
    }
}

