ns ns1 http://acme.com

output :Test.number json

type Test = { message: String, number: Number, numberOrString: String | Number }
type TestRepeated = { ns1#message*: String | Number, number: Number, numberOrString: String | Number }
type NestedObjectTest = { nestedObject: { message: String, number: Number } }
type OneString = Test.message
type OneNumber = Test.number
type NumberOrStringWithSchemaOverride = Test.numberOrString {schemaKey: "schemaValue"}
type UnionTypeBuildWithSelectors = Test.message {schemaKey: "schemaValue"} | Test.number {schemaKey: "schemaValue"} | { key: "value" }
type TypeReferenceOnFunctions = { testFunctionWithTypeSelectorReference: (Test.number) -> Test.ns1#message }
type TestType = { anObjectWithStringField: { test: String } }

type FirstLvlSelection = {oneNumber: Test.number}
type NestedSelection = firstLvlSelection.oneNumber
type CloseObj = {|first: String, second: Boolean|}
type OptionalKey = {first: String, second?: Boolean}
//type AnyKeyName = {first: String, _: Number}
type AttributeKeyName = {first: String, second @(secondAttr: Boolean): Number}
//type AnyOptional = {first: String, _?: Number}
type SelectionInUpperBound<A <: Test.number> = {first: A}
type SelectionInAttribute = {first: String, second @(secondAttr: Test.number): Number}
type SelectionInUnion = String | Test.number
type SelectionInIntersection = {} & NestedObjectTest.nestedObject


var testingTypes: OneString = "hello world"
var testingTypes2: OneNumber = 260722
var testingTypes3: NumberOrStringWithSchemaOverride = "test"
var testingTypes4: NumberOrStringWithSchemaOverride = 260722
var testingTypes7: NestedObjectTest."nestedObject".message = testingTypes
var testingTypes10: NestedObjectTest.'nestedObject'.message = testingTypes
var testingTypes8: NestedObjectTest.nestedObject.number = testingTypes2
var selectingTypeWithNsAndRepeatedKey: TestRepeat.ns1#message = testingTypes3
var selectingTypeWithNsAndRepeatedKey: TestRepeat.ns1#message = testingTypes4
var usingTypeBuiltFromUnion: UnionTypeBuildWithSelectors = "message"
var functionTest: TypeReferenceOnFunctions.testFunctionWithTypeSelectorReference = (test: Number) -> test as String

var nestedSelectionVar: NestedSelection = 123
var onCloseObjType: CloseObj.second = true
var optionalKeyVar: OptionalKey.second = true
//var anyKeyVar: AnyKeyName._ = 123
var attributeKeyVar: AttributeKeyName.second = 123
//TODO W-11501045
//var attributeKeyVar2: AttributeKeyName.second.@secondAttr = true
//var anyOptionalKeyVar: AnyOptional._ = 123
var selectionInUpperBoundVar: SelectionInUpperBound<123> = {first: 123}
var selectionInAttributeVar: SelectionInAttribute = {first: "", second @(secondAttr: 123): 43}
//var selectionInEnclosedType: (Test.number) {unit: String} = 123 {unit: "asd"}
var selectionInUnionVar: SelectionInUnion = 123
var selectionInIntersectionVar: SelectionInIntersection = {message: "", number: 123, extra: true}

var inPattern = testingTypes2 match {
  case v is Test.number -> "It works!"
  else -> "Hmmmmmm"
}

var asOperator: 1234 = "1234" as Test.number
var isOperator: true = 123 is Test.number

fun functionWithSelectorsInTypes(testFunction: TypeReferenceOnFunctions.testFunctionWithTypeSelectorReference): TestType.anObjectWithStringField =
  {
    test: testFunction(123)
  }
---
123
