package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.Message
import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.exception.WeaveException

class CompilationException(val messages: MessageCollector) extends WeaveException() {
  override def getMessage: String = {
    messages.errorMessageString()
  }

  def getErrorMessages(): Array[String] = {
    messages.errorMessages.map((entry) => Message.toMessageString(entry._1, entry._2)).toArray
  }

  def getWarningMessages(): Array[String] = {
    messages.warningMessages.map((entry) => Message.toMessageString(entry._1, entry._2)).toArray
  }
}
