package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ast.AstNode

class AstNodeVerificationPhase[R <: AstNode, T <: AstNodeResultAware[R]](transformers: Array[AstNodeVerifier]) extends VerificationPhase[T] {

  private def doTransform(node: AstNode, ctx: ParsingContext): Unit = {
    var i = 0
    while (i < transformers.length) {
      transformers(i).verify(node, ctx)
      i = i + 1
    }
  }

  private def traverse(node: AstNode, ctx: ParsingContext): Unit = {
    doTransform(node, ctx)
    val nodes = node.children()
    var i = 0
    while (i < nodes.length) {
      traverse(nodes(i), ctx)
      i = i + 1
    }
  }

  override def verify(source: T, context: ParsingContext): Unit = {
    traverse(source.astNode, context)
    SuccessResult(source, context)
  }
}

trait AstNodeVerifier {
  def verify(node: AstNode, context: ParsingContext): Unit
}