package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.DuplicatedNamespaceMessage
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.header.HeaderNode
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective

class NamespaceValidator extends AstNodeVerifier {
  override def verify(node: AstNode, context: ParsingContext): Unit = {
    node match {
      case HeaderNode(directives) => {
        directives.collect({
          case nd: NamespaceDirective => nd
        }).groupBy({
          _.prefix
        }).foreach({
          case (x, ys) if ys.size > 1 => {
            ys.foreach((ns) => {
              context.messageCollector.error(DuplicatedNamespaceMessage(ns.prefix.name), ns.location())
            })
          }
          case _ =>
        })
      }
      case _ =>
    }
  }
}