package org.mule.weave.v2.editor.quickfix

import org.mule.weave.v2.WeaveEditorSupport
import org.mule.weave.v2.completion.Template
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode

class CreateVariableDeclarationQuickFix(val editorSupport: WeaveEditorSupport, variable: VariableReferenceNode, argName: String) extends TemplateBasedQuickFixAction {

  override protected def createTemplate(): Template = {
    val template = Template().add(s"var ${argName}")
    template.add(" = ")
    template.placeHolder("???")
    template.newLine()
    template
  }

  override val element: AstNode = variable
}

