package org.mule.weave.v2.mapping

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.ts.WeaveType

/**
  * An expression mapping represents an expression applied to a target.
  * Literal assignments are the simplest of these.
  *
  * @param target         The target the expression will be applied to.
  * @param expressionNode The ast node (resulting from an expression) that will be assigned to the target.
  */
case class ExpressionAssignment(target: NamePathElement, expressionNode: AstNode, sourceType: Option[WeaveType] = None, targetType: Option[WeaveType] = None)