package org.mule.weave.v2.editor.indexing

import org.mule.weave.v2.editor.VirtualFile
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.phase.ParsingContext

/**
  * The indexer for weave files
  */
trait WeaveIndexer {

  /**
    * If true then it can be indexed
    * @param vf The file to index
    * @param context The context
    * @return True if is a valid VirtualFile
    */
  def parse(vf: VirtualFile, context: ParsingContext): Boolean

  /**
    * Returns all the identifieres declared in the specified Weave Document
    * @return All the used references
    */
  def identifiers(): Array[WeaveIdentifier]

  /**
    * Returns the document definition with its fully qualified name and what kind of
    * document is.
    * @return The WeaveDocument information
    */
  def document(): WeaveDocument

}

case class WeaveDocument(documentation: String, kind: Int)

case class WeaveIdentifier(startLocation: Int, endLocation: Int, value: String, idType: Int, kind: Int)

case class LocatedResult[T](moduleName: NameIdentifier, value: T)

object IdentifierType {
  val FUNCTION = 0
  val VARIABLE = 1
  val NAMESPACE = 2
  val TYPE = 3
  val ANNOTATION = 4
  val IMPORT = 5
}

object IdentifierKind {
  val REFERENCE = 0
  val DEFINITION = 1
}

object DocumentKind {
  val MODULE = 0
  val MAPPING = 1
}
