package org.mule.weave.v2.inspector

import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.phase.AstNodeResultAware
import org.mule.weave.v2.parser.phase.CompilationPhase
import org.mule.weave.v2.parser.phase.ParsingContext
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.parser.phase.ScopeNavigatorResultAware
import org.mule.weave.v2.parser.phase.SuccessResult

class ScopeCodeInspectorPhase[R <: AstNode, T <: AstNodeResultAware[R] with ScopeNavigatorResultAware](inspectors: Seq[CodeInspector[AstNodeResultAware[_] with ScopeNavigatorResultAware]]) extends CompilationPhase[T, T] {

  override def doCall(source: T, context: ParsingContext): PhaseResult[_ <: T] = {
    val rootNode: R = source.astNode
    AstNodeHelper.traverse(rootNode, (node) => {
      inspectors.foreach((inspector) => {
        inspector.inspect(node, source, context)
      })
      true
    })
    SuccessResult(source, context)
  }
}
