package org.mule.weave.v2.parser.phase

import org.mule.weave.v2.parser.ForwardReference
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.AstNodeHelper
import org.mule.weave.v2.parser.ast.functions.UsingVariableAssignment
import org.mule.weave.v2.parser.ast.header.directives.VarDirective
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode

class ForwardReferenceValidationPhase[T <: AstNode] extends VerificationPhase[ScopeGraphResult[T]] {

  override def verify(source: ScopeGraphResult[T], context: ParsingContext): Unit = {
    val nodes: Seq[VariableReferenceNode] = source.scope.astNavigator().allWithType(classOf[VariableReferenceNode])
    nodes.foreach(variableReference => {
      //Avoid $$ and injected variables as they are never forward reference
      if (!variableReference.variable.name.startsWith("$") && !variableReference.variable.name.startsWith("__")) {
        val maybeScope = source.scope.scopeOf(variableReference)
        maybeScope match {
          case Some(variableScope) =>
            val mayBeReference = source.scope.resolveVariable(variableReference.variable)
            mayBeReference match {
              case Some(reference) =>
                if (reference.scope.astNode eq variableScope.astNode) {
                  val navigator = variableScope.rootScope().astNavigator()
                  navigator.parentOf(reference.referencedNode).get match {
                    case vd: VarDirective =>
                      if (AstNodeHelper.containsChild(vd, variableReference)) {
                        context.messageCollector.error(ForwardReference(variableReference.variable), variableReference.location())
                      }
                    case vd: UsingVariableAssignment =>
                      if (AstNodeHelper.containsChild(vd, variableReference)) {
                        context.messageCollector.error(ForwardReference(variableReference.variable), variableReference.location())
                      }
                    case _ =>
                      if (reference.referencedNode.location().startPosition.index > variableReference.variable.location().startPosition.index) {
                        context.messageCollector.error(ForwardReference(variableReference.variable), variableReference.location())
                      }
                  }
                }
              case None =>
            }
          case None =>
        }
      }
    })
  }
}
