package org.mule.weave.v2.parser.ast.structure

import org.mule.weave.v2.api.tooling.ast.DWAstNodeKind
import org.mule.weave.v2.parser.ast.AstNode
import org.mule.weave.v2.parser.ast.Child
import org.mule.weave.v2.parser.ast.MutableAstNode

case class DynamicNameNode(var keyName: AstNode) extends AstNode with MutableAstNode {

  override def children(): Seq[AstNode] = Child(keyName)

  override protected def doClone(): AstNode = {
    copy(keyName.cloneAst())
  }

  override def getKind(): String = DWAstNodeKind.DYNAMIC_NAME_NODE

  override def update(toBeReplaced: AstNode, withNode: AstNode): Unit = {
    if (keyName eq toBeReplaced) keyName = withNode
  }
}