package org.mule.weave.v2.sdk

import org.mule.weave.v2.annotations.WeaveApi
import org.mule.weave.v2.parser.module.ModuleLoaderProvider

import java.util.ServiceLoader
import org.mule.weave.v2.parser.phase.ModuleLoader

import scala.collection.JavaConversions._

@WeaveApi(Seq("data-weave-agent"))
class SPIBasedModuleLoaderProvider(weaveResourceResolver: WeaveResourceResolver) extends ModuleLoaderProvider {

  val additionalModules: Seq[ModuleLoader] = loadModules()

  private def loadModules(): Seq[ModuleLoader] = {
    val modules = ServiceLoader.load(classOf[ModuleLoader], classOf[ModuleLoader].getClassLoader).iterator().toSeq
    modules.foreach({
      case rra: WeaveResourceResolverAware => rra.resolver(weaveResourceResolver)
      case _                               =>
    })
    modules
  }

  override def getModules: Seq[ModuleLoader] = {
    additionalModules
  }
}

object SPIBasedModuleLoaderProvider extends SPIBasedModuleLoaderProvider(ClassLoaderWeaveResourceResolver())

/**
  * Marks ModuleLoader to require ResourceResolver
  */
trait WeaveResourceResolverAware {
  def resolver(resolver: WeaveResourceResolver): Unit
}
